/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.controller;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.XNet;
import mcjty.xnet.client.ConnectorInfo;
import mcjty.xnet.utils.TagUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ChannelInfo {
    public static final int MAX_CHANNELS = 8;
    private final IChannelType type;
    private final IChannelSettings channelSettings;
    private String channelName;
    private boolean enabled = true;
    private final Map<SidedConsumer, ConnectorInfo> connectors = new HashMap<SidedConsumer, ConnectorInfo>();

    public ChannelInfo(IChannelType type) {
        this.type = type;
        this.channelSettings = type.createChannel();
    }

    @Nonnull
    public String getChannelName() {
        return this.channelName == null ? "" : this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public IChannelType getType() {
        return this.type;
    }

    public IChannelSettings getChannelSettings() {
        return this.channelSettings;
    }

    public Map<SidedConsumer, ConnectorInfo> getConnectors() {
        return this.connectors;
    }

    public ConnectorInfo createConnector(SidedConsumer id, boolean advanced) {
        ConnectorInfo info = new ConnectorInfo(this.type, id, advanced);
        this.connectors.put(id, info);
        return info;
    }

    public void writeToNBT(CompoundTag tag) {
        this.channelSettings.writeToNBT(tag);
        tag.m_128379_("enabled", this.enabled);
        if (this.channelName != null && !this.channelName.isEmpty()) {
            tag.m_128359_("name", this.channelName);
        }
        ListTag conlist = new ListTag();
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.connectors.entrySet()) {
            CompoundTag tc = new CompoundTag();
            ConnectorInfo connectorInfo = entry.getValue();
            connectorInfo.writeToNBT(tc);
            tc.m_128405_("consumerId", entry.getKey().consumerId().id());
            tc.m_128405_("side", entry.getKey().side().ordinal());
            tc.m_128359_("type", connectorInfo.getType().getID());
            tc.m_128379_("advanced", connectorInfo.isAdvanced());
            conlist.add((Object)tc);
        }
        tag.m_128365_("connectors", (Tag)conlist);
    }

    public void readFromNBT(CompoundTag tag) {
        this.channelSettings.readFromNBT(tag);
        this.enabled = tag.m_128471_("enabled");
        this.channelName = TagUtils.getStringOrNull(tag, "name");
        ListTag conlist = tag.m_128437_("connectors", 10);
        for (int i = 0; i < conlist.size(); ++i) {
            CompoundTag tc = conlist.m_128728_(i);
            String id = tc.m_128461_("type");
            IChannelType type = XNet.xNetApi.findType(id);
            if (type == null) {
                XNet.setup.getLogger().warn("Unsupported type " + id + "!");
                continue;
            }
            if (!this.getType().equals(type)) {
                XNet.setup.getLogger().warn("Trying to load a connector with non-matching type " + type + "!");
                continue;
            }
            ConsumerId consumerId = new ConsumerId(tc.m_128451_("consumerId"));
            Direction side = OrientationTools.DIRECTION_VALUES[tc.m_128451_("side")];
            SidedConsumer key = new SidedConsumer(consumerId, side);
            boolean advanced = tc.m_128471_("advanced");
            ConnectorInfo connectorInfo = new ConnectorInfo(type, key, advanced);
            connectorInfo.readFromNBT(tc);
            this.connectors.put(key, connectorInfo);
        }
    }
}

