/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.fluids;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.FluidTools;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mcjty.xnet.apiimpl.Constants;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.enums.InsExtMode;
import mcjty.xnet.setup.Config;
import mcjty.xnet.utils.CastTools;
import mcjty.xnet.utils.I18nConstants;
import mcjty.xnet.utils.TagUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FluidConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    private InsExtMode fluidMode = InsExtMode.INS;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer rate = null;
    @Nullable
    private Integer minmax = null;
    private int speed = 2;
    private ItemStack filter = ItemStack.f_41583_;
    private static final Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority", "flt"});
    private static final Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority", "flt", "speed"});

    public FluidConnectorSettings(@Nonnull Direction side) {
        super(side);
    }

    public InsExtMode getFluidMode() {
        return this.fluidMode;
    }

    public int getSpeed() {
        return this.speed;
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nonnull
    public Integer getRate() {
        return this.rate == null ? (Integer)Config.maxFluidRateNormal.get() : this.rate;
    }

    @Nullable
    public Integer getMinmax() {
        return this.minmax;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return switch (this.fluidMode) {
            default -> throw new IncompatibleClassChangeError();
            case InsExtMode.INS -> new IndicatorIcon(iconGuiElements, 0, 70, 13, 10);
            case InsExtMode.EXT -> new IndicatorIcon(iconGuiElements, 13, 70, 13, 10);
        };
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    private String getRateTooltip() {
        return I18nConstants.FLUID_RATE_TOOLTIP_FORMATTED.i18n((this.fluidMode == InsExtMode.EXT ? I18nConstants.EXT_ENDING : I18nConstants.INS_ENDING).i18n(new Object[0]), Config.getMaxFluidRate(this.advanced));
    }

    private String getMinMaxTooltip() {
        return I18nConstants.FLUID_MINMAX_TOOLTIP_FORMATTED.i18n((this.fluidMode == InsExtMode.EXT ? I18nConstants.EXT_ENDING : I18nConstants.INS_ENDING).i18n(new Object[0]), (this.fluidMode == InsExtMode.EXT ? I18nConstants.LOW_FORMAT : I18nConstants.HIGH_FORMAT).i18n(new Object[0]));
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        String[] speeds = (String[])Arrays.stream(this.advanced ? Constants.ADVANCED_SPEEDS : Constants.SPEEDS).map(s -> String.valueOf(Integer.parseInt(s) * 2)).toArray(String[]::new);
        int maxrate = Config.getMaxFluidRate(this.advanced);
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl();
        gui.translatableChoices("mode", (ITranslatableEnum)this.fluidMode, (ITranslatableEnum[])InsExtMode.values()).choices("speed", I18nConstants.SPEED_TOOLTIP.i18n(new Object[0]), Integer.toString(this.speed * 10), speeds).nl().label(I18nConstants.PRIORITY_LABEL.i18n(new Object[0])).integer("priority", I18nConstants.PRIORITY_TOOLTIP.i18n(new Object[0]), this.priority, 36).nl().label(I18nConstants.RATE_LABEL.i18n(new Object[0])).integer("rate", this.getRateTooltip(), this.rate, 36, Integer.valueOf(maxrate)).shift(10).label((this.fluidMode == InsExtMode.EXT ? I18nConstants.MIN : I18nConstants.MAX).i18n(new Object[0])).integer("minmax", this.getMinMaxTooltip(), this.minmax, 36).nl().label(I18nConstants.FILTER_LABEL.i18n(new Object[0])).ghostSlot("flt", this.filter);
    }

    public boolean isEnabled(String tag) {
        if (this.fluidMode == InsExtMode.INS) {
            if (tag.equals("facing")) {
                return this.advanced;
            }
            return INSERT_TAGS.contains(tag);
        }
        if (tag.equals("facing")) {
            return false;
        }
        return EXTRACT_TAGS.contains(tag);
    }

    @Nullable
    public FluidStack getMatcher() {
        if (!this.filter.m_41619_()) {
            return FluidTools.convertBucketToFluid((ItemStack)this.filter);
        }
        return null;
    }

    public void setSpeed(int speed) {
        this.speed = speed != 0 ? speed : 2;
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.fluidMode = CastTools.safeInsExtMode(data.get("mode"));
        this.rate = (Integer)data.get("rate");
        this.minmax = (Integer)data.get("minmax");
        this.priority = (Integer)data.get("priority");
        this.setSpeed(Integer.parseInt((String)data.get("speed")) / 10);
        this.filter = CastTools.safeItemStack(data.get("flt"));
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        FluidConnectorSettings.setEnumSafe((JsonObject)object, (String)"fluidMode", (Enum)this.fluidMode);
        FluidConnectorSettings.setIntegerSafe((JsonObject)object, (String)"priority", (Integer)this.priority);
        FluidConnectorSettings.setIntegerSafe((JsonObject)object, (String)"rate", (Integer)this.rate);
        FluidConnectorSettings.setIntegerSafe((JsonObject)object, (String)"rate", (Integer)this.minmax);
        FluidConnectorSettings.setIntegerSafe((JsonObject)object, (String)"speed", (Integer)this.speed);
        if (!this.filter.m_41619_()) {
            object.add("flt", (JsonElement)JSonTools.itemStackToJson((ItemStack)this.filter));
        }
        if (this.rate != null && this.rate > (Integer)Config.maxFluidRateNormal.get() || this.speed == 1) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.fluidMode = (InsExtMode)FluidConnectorSettings.getEnumSafe((JsonObject)object, (String)"fluidMode", EnumStringTranslators::getFluidMode);
        this.priority = FluidConnectorSettings.getIntegerSafe((JsonObject)object, (String)"priority");
        this.rate = FluidConnectorSettings.getIntegerSafe((JsonObject)object, (String)"rate");
        this.minmax = FluidConnectorSettings.getIntegerSafe((JsonObject)object, (String)"rate");
        this.speed = FluidConnectorSettings.getIntegerNotNull((JsonObject)object, (String)"speed");
        this.filter = object.has("flt") ? JSonTools.jsonToItemStack((JsonObject)object.get("flt").getAsJsonObject()) : ItemStack.f_41583_;
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.fluidMode = InsExtMode.values()[tag.m_128445_("fluidMode")];
        this.priority = TagUtils.getIntOrNull(tag, "priority");
        this.rate = TagUtils.getIntOrNull(tag, "rate");
        this.minmax = TagUtils.getIntOrNull(tag, "minmax");
        this.speed = TagUtils.getIntOrValue(tag, "speed", 2);
        if (tag.m_128441_("flt")) {
            CompoundTag itemTag = tag.m_128469_("flt");
            this.filter = ItemStack.m_41712_((CompoundTag)itemTag);
        } else {
            this.filter = ItemStack.f_41583_;
        }
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_("fluidMode", (byte)this.fluidMode.ordinal());
        TagUtils.putIntIfNotNull(tag, "priority", this.priority);
        TagUtils.putIntIfNotNull(tag, "rate", this.rate);
        TagUtils.putIntIfNotNull(tag, "minmax", this.minmax);
        tag.m_128405_("speed", this.speed);
        if (!this.filter.m_41619_()) {
            CompoundTag itemTag = new CompoundTag();
            this.filter.m_41739_(itemTag);
            tag.m_128365_("flt", (Tag)itemTag);
        }
    }
}

