/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellBlock;
import com.supermartijn642.wormhole.portal.PortalShape;
import com.supermartijn642.wormhole.targetcell.TargetCellBlock;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PortalRendererHelper {
    private static final int ROTATE_TIME = 20000;

    public static void drawPortal(PoseStack poseStack, PortalShape shape, float x, float y, float width, float height) {
        Level level = ClientUtils.getWorld();
        float scale = Math.min(width, height) / ((float)shape.span + 1.0f);
        Vector3f center = new Vector3f((float)(shape.maxCorner.m_123341_() + shape.minCorner.m_123341_()) / 2.0f, (float)(shape.maxCorner.m_123342_() + shape.minCorner.m_123342_()) / 2.0f, (float)(shape.maxCorner.m_123343_() + shape.minCorner.m_123343_()) / 2.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(x + width / 2.0f, y + height / 2.0f, 350.0f);
        poseStack.m_85841_(scale, -scale, scale);
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f));
        poseStack.m_252781_(new Quaternionf().setAngleAxis(0.7853981633974483, 1.0, 0.0, 0.0));
        poseStack.m_252781_(new Quaternionf().setAngleAxis((double)(System.currentTimeMillis() % 20000L) / 20000.0 * Math.PI, 0.0, 1.0, 0.0));
        poseStack.m_252880_(-center.x(), -center.y(), -center.z());
        for (BlockPos pos : shape.frame) {
            PortalRendererHelper.renderBlock(level, pos, poseStack, (MultiBufferSource)bufferSource, true);
        }
        for (BlockPos pos : shape.area) {
            if (level.m_46859_(pos)) continue;
            PortalRendererHelper.renderBlock(level, pos, poseStack, (MultiBufferSource)bufferSource, level.m_8055_(pos).m_60734_() instanceof PortalBlock);
            PortalRendererHelper.renderBlockEntity(level, pos, poseStack, (MultiBufferSource)bufferSource);
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
    }

    private static void renderBlock(Level level, BlockPos pos, PoseStack poseStack, MultiBufferSource bufferSource, boolean valid) {
        BlockState state = level.m_8055_(pos);
        if (!(state.m_60734_() instanceof EnergyCellBlock) && !(state.m_60734_() instanceof TargetCellBlock) && state.m_60799_() != RenderShape.MODEL) {
            return;
        }
        BlockEntity entity = level.m_7702_(pos);
        BakedModel model = ClientUtils.getBlockRenderer().m_110910_(state);
        ModelData modelData = entity == null ? ModelData.EMPTY : entity.getModelData();
        modelData = model.getModelData((BlockAndTintGetter)level, pos, state, modelData);
        poseStack.m_85836_();
        poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        PortalRendererHelper.translateAndRenderModel(state, poseStack, bufferSource, 0xF000F0, OverlayTexture.f_118083_, model, modelData, valid);
        poseStack.m_85849_();
    }

    private static void translateAndRenderModel(BlockState state, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, BakedModel model, ModelData modelData, boolean valid) {
        poseStack.m_85836_();
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.m_216335_((long)42L), modelData)) {
            PortalRendererHelper.renderModel(model, state, combinedLight, combinedOverlay, poseStack, bufferSource.m_6299_(renderType), modelData, renderType, valid);
        }
        poseStack.m_85849_();
    }

    private static void renderModel(BakedModel model, BlockState state, int combinedLight, int combinedOverlay, PoseStack poseStack, VertexConsumer buffer, ModelData modelData, RenderType renderType, boolean valid) {
        RandomSource random = RandomSource.m_216327_();
        for (Direction direction : Direction.values()) {
            random.m_188584_(42L);
            PortalRendererHelper.renderQuads(poseStack, buffer, model.getQuads(state, direction, random, modelData, renderType), combinedLight, combinedOverlay, valid);
        }
        random.m_188584_(42L);
        PortalRendererHelper.renderQuads(poseStack, buffer, model.getQuads(state, null, random, modelData, renderType), combinedLight, combinedOverlay, valid);
    }

    private static void renderQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, int combinedLight, int combinedOverlay, boolean valid) {
        PoseStack.Pose matrix = poseStack.m_85850_();
        for (BakedQuad bakedquad : quads) {
            buffer.putBulkData(matrix, bakedquad, 1.0f, valid ? 1.0f : 0.5f, valid ? 1.0f : 0.5f, valid ? 1.0f : 0.8f, combinedLight, combinedOverlay, false);
        }
    }

    private static void renderBlockEntity(Level level, BlockPos pos, PoseStack poseStack, MultiBufferSource bufferSource) {
        BlockEntityRenderer entityRenderer;
        BlockEntity entity = level.m_7702_(pos);
        if (entity != null && (entityRenderer = ClientUtils.getMinecraft().m_167982_().m_112265_(entity)) != null) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)pos.m_123341_() - 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() - 0.5);
            entityRenderer.m_6922_(entity, ClientUtils.getMinecraft().m_91296_(), poseStack, bufferSource, 0xF000F0, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
    }
}

