/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.portal.PortalTarget;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportHelper {
    private static final int TELEPORT_COOLDOWN = 40;

    public static boolean queTeleport(Entity entity, PortalTarget target) {
        if (!TeleportHelper.canTeleport(entity, target)) {
            return false;
        }
        for (Entity passenger : entity.m_146897_()) {
            if (!(passenger instanceof Player)) continue;
            return false;
        }
        Entity lowestEntity = entity.m_20201_();
        if (!entity.m_9236_().f_46443_) {
            lowestEntity.m_9236_().m_7654_().m_6937_((Runnable)new TickTask(0, () -> TeleportHelper.teleportEntityAndPassengers(lowestEntity, null, target)));
            TeleportHelper.markEntityAndPassengers(lowestEntity);
        }
        return true;
    }

    public static boolean canTeleport(Entity entity, PortalTarget target) {
        if (entity.m_9236_().f_46443_ || !target.getLevel(entity.m_20194_()).isPresent()) {
            return false;
        }
        if (entity.m_20159_()) {
            return TeleportHelper.canTeleport(entity.m_20201_(), target);
        }
        for (Entity rider : entity.m_146897_()) {
            CompoundTag tag = rider.getPersistentData();
            if (!tag.m_128441_("wormhole:teleported") || (long)rider.f_19797_ - tag.m_128454_("wormhole:teleported") < 0L || (long)rider.f_19797_ - tag.m_128454_("wormhole:teleported") >= 40L) continue;
            return false;
        }
        CompoundTag tag = entity.getPersistentData();
        return !tag.m_128441_("wormhole:teleported") || (long)entity.f_19797_ - tag.m_128454_("wormhole:teleported") < 0L || (long)entity.f_19797_ - tag.m_128454_("wormhole:teleported") >= 40L;
    }

    private static void markEntityAndPassengers(Entity entity) {
        entity.getPersistentData().m_128356_("wormhole:teleported", (long)entity.f_19797_);
        entity.m_20197_().forEach(TeleportHelper::markEntityAndPassengers);
    }

    private static void teleportEntityAndPassengers(Entity entity, Entity entityBeingRidden, PortalTarget target) {
        if (entity.m_9236_().f_46443_ || !target.getLevel(entity.m_20194_()).isPresent()) {
            return;
        }
        Optional<ServerLevel> targetLevel = target.getLevel(entity.m_20194_()).filter(ServerLevel.class::isInstance).map(ServerLevel.class::cast);
        if (!targetLevel.isPresent()) {
            return;
        }
        List passengers = entity.m_20197_();
        entity.m_20153_();
        Entity newEntity = TeleportHelper.teleportEntity(entity, targetLevel.get(), target);
        if (entityBeingRidden != null) {
            newEntity.m_20329_(entityBeingRidden);
            if (newEntity instanceof ServerPlayer) {
                ((ServerPlayer)newEntity).f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket(entityBeingRidden));
            }
        }
        passengers.forEach(e -> TeleportHelper.teleportEntityAndPassengers(e, newEntity, target));
    }

    private static Entity teleportEntity(Entity entity, ServerLevel targetLevel, PortalTarget target) {
        ChunkPos targetChunkPos = new ChunkPos(target.getPos());
        targetLevel.m_7726_().m_8387_(TicketType.f_9448_, targetChunkPos, 1, (Object)entity.m_19879_());
        if (targetLevel == entity.m_9236_()) {
            if (entity instanceof ServerPlayer) {
                ((ServerPlayer)entity).m_8999_(targetLevel, (double)target.x + 0.5, (double)target.y + 0.2, (double)target.z + 0.5, target.yaw, 0.0f);
            } else {
                entity.m_6021_((double)target.x + 0.5, (double)target.y + 0.2, (double)target.z + 0.5);
            }
            entity.m_5616_(target.yaw);
            entity.m_20256_(Vec3.f_82478_);
            entity.f_19789_ = 0.0f;
            entity.m_6853_(true);
            return entity;
        }
        return entity.changeDimension(targetLevel, (ITeleporter)new WormholeTeleporter(target));
    }

    private static class WormholeTeleporter
    implements ITeleporter {
        private final PortalTarget target;

        public WormholeTeleporter(PortalTarget target) {
            this.target = target;
        }

        public Entity placeEntity(Entity entity, ServerLevel currentLevel, ServerLevel destLevel, float yaw, Function<Boolean, Entity> repositionEntity) {
            return repositionEntity.apply(false);
        }

        @Nullable
        public PortalInfo getPortalInfo(Entity entity, ServerLevel destLevel, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            return new PortalInfo(this.target.getCenteredPos(), Vec3.f_82478_, this.target.yaw, 0.0f);
        }
    }
}

