/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.wormhole.PortalGroupCapability;
import com.supermartijn642.wormhole.StabilizerBlock;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeClient;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.IEnergyCellEntity;
import com.supermartijn642.wormhole.portal.ITargetCellEntity;
import com.supermartijn642.wormhole.portal.PortalGroupBlockEntity;
import com.supermartijn642.wormhole.portal.PortalShape;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class StabilizerBlockEntity
extends PortalGroupBlockEntity
implements ITargetCellEntity,
IEnergyCellEntity {
    private final List<PortalTarget> targets = new ArrayList<PortalTarget>();
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this);
    private int energy = 0;

    public StabilizerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)Wormhole.stabilizer_tile, pos, state);
        for (int i = 0; i < this.getTargetCapacity(); ++i) {
            this.targets.add(null);
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.f_58857_.f_46443_ && this.m_58900_().m_60734_() instanceof StabilizerBlock && this.hasGroup() != ((Boolean)this.m_58900_().m_61143_((Property)StabilizerBlock.ON_PROPERTY)).booleanValue()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)Wormhole.portal_stabilizer.m_49966_().m_61124_((Property)StabilizerBlock.ON_PROPERTY, (Comparable)Boolean.valueOf(this.hasGroup())), 2);
        }
    }

    public boolean activate(Player player) {
        if (this.hasGroup()) {
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof TargetDeviceItem)) {
                stack = player.m_21120_(InteractionHand.OFF_HAND);
            }
            if (stack.m_41720_() instanceof TargetDeviceItem) {
                if (this.f_58857_.f_46443_) {
                    WormholeClient.openPortalTargetScreen(this.f_58858_);
                }
            } else if (this.f_58857_.f_46443_) {
                WormholeClient.openPortalOverviewScreen(this.f_58858_);
            }
        } else if (!this.f_58857_.f_46443_) {
            PortalShape shape = PortalShape.find((BlockGetter)this.f_58857_, this.f_58858_);
            if (shape == null) {
                player.m_5661_((Component)TextComponents.translation((String)"wormhole.portal_stabilizer.error").color(ChatFormatting.RED).get(), true);
            } else {
                this.f_58857_.getCapability(PortalGroupCapability.CAPABILITY).ifPresent(groups -> groups.add(shape));
                player.m_5661_((Component)TextComponents.translation((String)"wormhole.portal_stabilizer.success").color(ChatFormatting.YELLOW).get(), true);
            }
        }
        return true;
    }

    @Override
    public int getTargetCapacity() {
        return WormholeConfig.stabilizerTargetCapacity.get();
    }

    @Override
    public PortalTarget getTarget(int index) {
        return this.targets.get(index);
    }

    @Override
    public void setTarget(int index, PortalTarget target) {
        this.targets.set(index, target);
        this.dataChanged();
    }

    @Override
    public List<PortalTarget> getTargets() {
        return this.targets;
    }

    @Override
    public int getNonNullTargetCount() {
        int count = 0;
        for (PortalTarget target : this.targets) {
            if (target == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate, boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().receiveEnergy(maxReceive, simulate);
        }
        if (maxReceive < 0) {
            return -this.extractEnergy(-maxReceive, simulate);
        }
        int absorb = Math.min(this.getMaxEnergyStored(true) - this.energy, maxReceive);
        if (!simulate) {
            this.energy += absorb;
            if (absorb > 0) {
                this.dataChanged();
            }
        }
        return absorb;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate, boolean fromGroup) {
        if (maxExtract < 0) {
            return -this.receiveEnergy(-maxExtract, simulate);
        }
        int drain = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= drain;
            if (drain > 0) {
                this.dataChanged();
            }
        }
        return drain;
    }

    @Override
    public int getEnergyStored(boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().getStoredEnergy();
        }
        return Math.min(this.energy, this.getMaxEnergyStored(true));
    }

    @Override
    public int getMaxEnergyStored(boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().getEnergyCapacity();
        }
        return WormholeConfig.stabilizerEnergyCapacity.get();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCapability.invalidate();
    }

    @Override
    protected CompoundTag writeData() {
        CompoundTag tag = super.writeData();
        CompoundTag targetsTag = new CompoundTag();
        int count = 0;
        for (int i = 0; i < this.targets.size(); ++i) {
            targetsTag.m_128379_("has" + i, this.targets.get(i) != null);
            if (this.targets.get(i) == null) continue;
            targetsTag.m_128365_("target" + i, (Tag)this.targets.get(i).write());
            count = i + 1;
        }
        tag.m_128405_("targetCount", count);
        tag.m_128365_("targets", (Tag)targetsTag);
        tag.m_128405_("energy", this.energy);
        return tag;
    }

    @Override
    protected void readData(CompoundTag tag) {
        CompoundTag groupTag;
        super.readData(tag);
        this.targets.clear();
        int count = tag.m_128441_("targetCount") ? tag.m_128451_("targetCount") : 0;
        CompoundTag targetsTag = tag.m_128469_("targets");
        for (int i = 0; i < this.getTargetCapacity(); ++i) {
            if (i < count && targetsTag.m_128441_("has" + i) && targetsTag.m_128471_("has" + i) && targetsTag.m_128441_("target" + i)) {
                this.targets.add(new PortalTarget(targetsTag.m_128469_("target" + i)));
                continue;
            }
            this.targets.add(null);
        }
        int n = this.energy = tag.m_128441_("energy") ? tag.m_128451_("energy") : 0;
        if (tag.m_128441_("group") && (groupTag = new CompoundTag()).m_128441_("target")) {
            this.targets.set(0, PortalTarget.read(groupTag.m_128469_("target")));
        }
    }
}

