/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.tcredstone.tile;

import com.troblecodings.linkableapi.ILinkableTile;
import com.troblecodings.tcredstone.block.BlockRedstoneAcceptor;
import com.troblecodings.tcredstone.init.GIRCInit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileRedstoneMultiEmitter
extends BlockEntity
implements ILinkableTile {
    private List<BlockPos> listOfPositions = new ArrayList<BlockPos>();
    private static final String LINKED_POS_LIST = "linkedPos";

    public TileRedstoneMultiEmitter(BlockPos pos, BlockState state) {
        super((BlockEntityType)GIRCInit.MULTI_EMITER_TILE.get(), pos, state);
    }

    public CompoundTag writeBlockPosToNBT(List<BlockPos> pos, CompoundTag compound) {
        if (pos != null && compound != null) {
            ListTag list = new ListTag();
            this.listOfPositions.forEach(blockpos -> {
                CompoundTag item = NbtUtils.m_129224_((BlockPos)blockpos);
                list.add((Object)item);
            });
            compound.m_128365_(LINKED_POS_LIST, (Tag)list);
        }
        return compound;
    }

    public List<BlockPos> readBlockPosFromNBT(CompoundTag compound) {
        ListTag list = (ListTag)compound.m_128423_(LINKED_POS_LIST);
        if (list != null) {
            this.listOfPositions.clear();
            list.forEach(pos -> {
                CompoundTag item = (CompoundTag)pos;
                this.listOfPositions.add(NbtUtils.m_129239_((CompoundTag)item));
            });
            return this.listOfPositions;
        }
        return null;
    }

    @Override
    public boolean hasLink() {
        return !this.listOfPositions.isEmpty();
    }

    @Override
    public boolean link(BlockPos pos) {
        if (pos != null && !this.listOfPositions.contains(pos)) {
            this.listOfPositions.add(pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean unlink() {
        if (this.listOfPositions.isEmpty()) {
            return false;
        }
        this.listOfPositions.clear();
        return true;
    }

    public List<BlockPos> getLinkedPos() {
        return this.listOfPositions;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.listOfPositions = this.readBlockPosFromNBT(compound);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeBlockPosToNBT(this.listOfPositions, compound);
    }

    public void redstoneUpdate(boolean enabled) {
        this.listOfPositions.forEach(blockpos -> TileRedstoneMultiEmitter.redstoneUpdate(enabled, blockpos, this.f_58857_));
    }

    public static boolean redstoneUpdate(boolean enabled, BlockPos linkedpos, Level level) {
        BlockState state;
        if (linkedpos != null && (state = level.m_8055_(linkedpos)).m_60734_() instanceof BlockRedstoneAcceptor) {
            level.m_7731_(linkedpos, (BlockState)state.m_61124_((Property)BlockRedstoneAcceptor.POWER, (Comparable)Boolean.valueOf(enabled)), 3);
        }
        return enabled;
    }

    public static boolean redstoneUpdate(BlockPos linkedpos, Level level) {
        BlockState state;
        if (linkedpos != null && (state = level.m_8055_(linkedpos)).m_60734_() instanceof BlockRedstoneAcceptor) {
            boolean newState = (Boolean)state.m_61143_((Property)BlockRedstoneAcceptor.POWER) == false;
            level.m_7731_(linkedpos, (BlockState)state.m_61124_((Property)BlockRedstoneAcceptor.POWER, (Comparable)Boolean.valueOf(newState)), 3);
            return newState;
        }
        return false;
    }
}

