/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.linkableapi;

import com.google.common.base.Predicate;
import com.troblecodings.linkableapi.ILinkableTile;
import com.troblecodings.linkableapi.TaggableFunction;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class MultiLinkingTool
extends Item {
    private static final String LINKED_BLOCKS = "linkedBlocks";
    private final BiPredicate<Level, BlockPos> predicate;
    private final Predicate<BlockEntity> predicateSet;
    private final CreativeModeTab tab;
    private final TaggableFunction tagFromFunction;

    public MultiLinkingTool(CreativeModeTab tab, BiPredicate<Level, BlockPos> predicate) {
        this(tab, predicate, (Predicate<BlockEntity>)((Predicate)_u -> true));
    }

    public MultiLinkingTool(CreativeModeTab tab, BiPredicate<Level, BlockPos> predicate, Predicate<BlockEntity> predicateSet, TaggableFunction function) {
        super(new Item.Properties().m_41503_(64).setNoRepair());
        this.predicate = predicate;
        this.predicateSet = predicateSet;
        this.tagFromFunction = function;
        this.tab = tab;
        if (tab != null) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onTab);
        }
    }

    public MultiLinkingTool(CreativeModeTab tab, BiPredicate<Level, BlockPos> predicate, Predicate<BlockEntity> predicateSet) {
        this(tab, predicate, predicateSet, (_u1, _u2, _u3) -> {});
    }

    private void onTab(BuildCreativeModeTabContentsEvent ev) {
        if (ev.getTab().equals(this.tab)) {
            ev.m_246326_(() -> this);
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        Level levelIn = ctx.m_43725_();
        Player player = ctx.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = ctx.m_8083_();
        if (levelIn.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockEntity entity = levelIn.m_7702_(pos);
        if (entity instanceof ILinkableTile && this.predicateSet.apply((Object)entity)) {
            ILinkableTile controller = (ILinkableTile)entity;
            if (!player.m_6144_()) {
                CompoundTag comp = stack.m_41783_();
                if (comp == null) {
                    this.message(player, "lt.notset", pos.toString());
                    return InteractionResult.PASS;
                }
                ListTag list = (ListTag)comp.m_128423_(LINKED_BLOCKS);
                if (list == null) {
                    this.message(player, "lt.notlinked", new Object[0]);
                    return InteractionResult.FAIL;
                }
                list.stream().map(tag -> NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag))).forEach(linkPos -> {
                    if (controller.link((BlockPos)linkPos)) {
                        this.message(player, "lt.linkedpos", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    }
                });
                stack.m_41751_(null);
                this.message(player, "lt.reset", new Object[0]);
                return InteractionResult.FAIL;
            }
            if (controller.hasLink() && controller.unlink()) {
                this.message(player, "lt.unlink", new Object[0]);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.predicate.test(levelIn, pos)) {
            ListTag list;
            CompoundTag tag2 = stack.m_41783_();
            if (tag2 == null) {
                tag2 = new CompoundTag();
            }
            if ((list = (ListTag)tag2.m_128423_(LINKED_BLOCKS)) == null) {
                list = new ListTag();
            }
            list.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            tag2.m_128365_(LINKED_BLOCKS, (Tag)list);
            this.tagFromFunction.test(levelIn, pos, tag2);
            stack.m_41751_(tag2);
            this.message(player, "lt.setpos", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            this.message(player, "lt.setpos.msg", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && stack.m_41783_() != null) {
            stack.m_41751_(null);
            this.message(player, "lt.reset", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        ListTag list;
        CompoundTag itemTag = stack.m_41783_();
        if (itemTag != null && (list = (ListTag)itemTag.m_128423_(LINKED_BLOCKS)) != null) {
            this.tooltip(tooltip, "lt.linkedpos", list.stream().map(tag -> NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag))).collect(Collectors.toList()));
            return;
        }
        this.tooltip(tooltip, "lt.notlinked", new Object[0]);
        this.tooltip(tooltip, "lt.notlinked.msg", new Object[0]);
    }

    public void tooltip(List list, String text, Object ... obj) {
        list.add(this.getComponent(text, obj));
    }

    public void message(Player player, String text, Object ... obj) {
        player.m_213846_((Component)this.getComponent(text, obj));
    }

    public MutableComponent getComponent(String text, Object ... obj) {
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents(text, text, obj));
    }
}

