/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.linkableapi;

import com.google.common.base.Predicate;
import com.troblecodings.linkableapi.ILinkableTile;
import com.troblecodings.linkableapi.Message;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class Linkingtool
extends Item
implements Message {
    private final BiPredicate<Level, BlockPos> predicate;
    private final Predicate<BlockEntity> predicateSet;
    private final CreativeModeTab tab;

    public Linkingtool(CreativeModeTab tab, BiPredicate<Level, BlockPos> predicate) {
        this(tab, predicate, (Predicate<BlockEntity>)((Predicate)_u -> true));
    }

    public Linkingtool(CreativeModeTab tab, BiPredicate<Level, BlockPos> predicate, Predicate<BlockEntity> predicateSet) {
        super(new Item.Properties());
        this.predicate = predicate;
        this.predicateSet = predicateSet;
        this.tab = tab;
        if (tab != null) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onTab);
        }
    }

    private void onTab(BuildCreativeModeTabContentsEvent ev) {
        if (ev.getTab().equals(this.tab)) {
            ev.m_246326_(() -> this);
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        Level levelIn = ctx.m_43725_();
        Player player = ctx.m_43723_();
        BlockPos pos = ctx.m_8083_();
        if (levelIn.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockEntity entity = levelIn.m_7702_(pos);
        if (entity instanceof ILinkableTile && this.predicateSet.apply((Object)entity)) {
            ILinkableTile controller = (ILinkableTile)entity;
            if (!player.m_6144_()) {
                CompoundTag comp = stack.m_41783_();
                if (comp == null) {
                    this.message(player, "lt.notset", new Object[]{pos.toString()});
                    return InteractionResult.PASS;
                }
                BlockPos lpos = NbtUtils.m_129239_((CompoundTag)comp);
                if (controller.link(lpos)) {
                    this.message(player, "lt.linkedpos", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
                    stack.m_41751_(null);
                    this.message(player, "lt.reset", new Object[0]);
                    return InteractionResult.FAIL;
                }
                this.message(player, "lt.notlinked", new Object[0]);
                this.message(player, "lt.notlinked.msg", new Object[0]);
                return InteractionResult.FAIL;
            }
            if (controller.hasLink() && controller.unlink()) {
                this.message(player, "lt.unlink", new Object[0]);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.predicate.test(levelIn, pos)) {
            if (stack.m_41783_() != null) {
                this.message(player, "lt.setpos.msg", new Object[0]);
                return InteractionResult.FAIL;
            }
            CompoundTag comp = NbtUtils.m_129224_((BlockPos)pos);
            stack.m_41751_(comp);
            this.message(player, "lt.setpos", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
            this.message(player, "lt.setpos.msg", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && stack.m_41783_() != null) {
            stack.m_41751_(null);
            this.message(player, "lt.reset", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        BlockPos pos;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && (pos = NbtUtils.m_129239_((CompoundTag)nbt)) != null) {
            this.tooltip(tooltip, "lt.linkedpos", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            return;
        }
        this.tooltip(tooltip, "lt.notlinked", new Object[0]);
        this.tooltip(tooltip, "lt.notlinked.msg", new Object[0]);
    }

    public void tooltip(List list, String text, Object ... obj) {
        list.add(this.getComponent(text, obj));
    }
}

