/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import de.maxhenkel.plane.ClientConfig;
import de.maxhenkel.plane.Main;
import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    private static final ResourceLocation PLANE_INFO_TEXTURE = new ResourceLocation("plane", "textures/gui/plane_info.png");
    private Minecraft mc = Minecraft.m_91087_();
    private EntityPlaneSoundBase lastVehicle;
    private double cachedRelativeHeight = 0.0;

    @SubscribeEvent
    public void onRender(ViewportEvent.ComputeCameraAngles evt) {
        if (this.getPlane() != null && !this.mc.f_91066_.m_92176_().m_90612_()) {
            evt.getCamera().m_90568_(-evt.getCamera().m_90566_((Double)Main.CLIENT_CONFIG.planeZoom.get() - 4.0), 0.0, 0.0);
        }
    }

    @SubscribeEvent
    public void onRender(InputEvent.MouseScrollingEvent evt) {
        if (this.getPlane() != null && !this.mc.f_91066_.m_92176_().m_90612_()) {
            Main.CLIENT_CONFIG.planeZoom.set((Object)Math.max(1.0, Math.min(20.0, (Double)Main.CLIENT_CONFIG.planeZoom.get() - evt.getScrollDelta())));
            Main.CLIENT_CONFIG.planeZoom.save();
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRender(RenderGuiOverlayEvent.Post evt) {
        LocalPlayer player = this.mc.f_91074_;
        Entity e = player.m_20202_();
        if (!(e instanceof EntityPlaneSoundBase)) {
            return;
        }
        EntityPlaneSoundBase plane = (EntityPlaneSoundBase)e;
        if (((Boolean)Main.CLIENT_CONFIG.showPlaneInfo.get()).booleanValue()) {
            this.renderPlaneInfo(evt.getGuiGraphics(), plane);
        }
    }

    public void renderPlaneInfo(GuiGraphics guiGraphics, EntityPlaneSoundBase plane) {
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int texWidth = 110;
        int texHeight = 90;
        int height = this.mc.m_91268_().m_85446_();
        int width = this.mc.m_91268_().m_85445_();
        float scale = ((Double)Main.CLIENT_CONFIG.planeInfoScale.get()).floatValue();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280168_().m_85837_((double)(-width), (double)(-height), 0.0);
        guiGraphics.m_280168_().m_85837_((double)width * (1.0 / (double)scale), (double)height * (1.0 / (double)scale), 0.0);
        int padding = 3;
        int yStart = height - texHeight - padding;
        int xStart = width - texWidth - padding;
        guiGraphics.m_280218_(PLANE_INFO_TEXTURE, xStart, yStart, 0, 0, texWidth, texHeight);
        Font font = this.mc.f_91065_.m_93082_();
        Function<Integer, Integer> heightFunc = integer -> {
            Objects.requireNonNull(font);
            return yStart + 8 + (9 + 2) * integer;
        };
        guiGraphics.m_280649_(font, Component.m_237110_((String)"tooltip.plane.speed", (Object[])new Object[]{((ClientConfig.SpeedType)((Object)Main.CLIENT_CONFIG.planeInfoSpeedType.get())).getTextComponent(plane.m_20184_().m_82553_())}).m_7532_(), xStart + 7, heightFunc.apply(0).intValue(), 0, false);
        guiGraphics.m_280649_(font, Component.m_237110_((String)"tooltip.plane.vertical_speed", (Object[])new Object[]{((ClientConfig.SpeedType)((Object)Main.CLIENT_CONFIG.planeInfoSpeedType.get())).getTextComponent(plane.m_20184_().m_7098_())}).m_7532_(), xStart + 7, heightFunc.apply(1).intValue(), 0, false);
        guiGraphics.m_280649_(font, Component.m_237110_((String)"tooltip.plane.throttle", (Object[])new Object[]{String.valueOf(Math.round(plane.getEngineSpeed() * 100.0f))}).m_7532_(), xStart + 7, heightFunc.apply(2).intValue(), 0, false);
        guiGraphics.m_280649_(font, Component.m_237110_((String)"tooltip.plane.height", (Object[])new Object[]{String.valueOf(Math.round(plane.m_20186_()))}).m_7532_(), xStart + 7, heightFunc.apply(3).intValue(), 0, false);
        guiGraphics.m_280649_(font, Component.m_237110_((String)"tooltip.plane.relative_height", (Object[])new Object[]{String.valueOf(Math.round(this.cachedRelativeHeight))}).m_7532_(), xStart + 7, heightFunc.apply(4).intValue(), 0, false);
        guiGraphics.m_280649_(font, Component.m_237110_((String)"tooltip.plane.fuel", (Object[])new Object[]{String.valueOf(plane.getFuel())}).m_7532_(), xStart + 7, heightFunc.apply(5).intValue(), 0, false);
        guiGraphics.m_280649_(font, Component.m_237110_((String)"tooltip.plane.damage", (Object[])new Object[]{String.valueOf(MathUtils.round(plane.getPlaneDamage(), 2))}).m_7532_(), xStart + 7, heightFunc.apply(6).intValue(), 0, false);
        guiGraphics.m_280168_().m_85849_();
    }

    private double getRelativeHeight(EntityPlaneSoundBase plane) {
        int highestBlock = (int)plane.m_20186_();
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(plane.m_20185_(), plane.m_20186_(), plane.m_20189_());
        for (int y = highestBlock; y >= plane.m_9236_().m_141937_(); --y) {
            p.m_142448_(y);
            if (!plane.m_9236_().m_8055_((BlockPos)p).m_60815_()) continue;
            highestBlock = y;
            break;
        }
        return plane.m_20186_() - (double)(highestBlock + 1);
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (player.m_20202_() instanceof EntityPlaneSoundBase) {
            EntityPlaneSoundBase plane = (EntityPlaneSoundBase)event.getEntity().m_20202_();
            event.getPoseStack().m_85836_();
            event.getPoseStack().m_252781_(Axis.f_252436_.m_252977_(-(plane.f_19859_ + (plane.m_146908_() - plane.f_19859_) * event.getPartialTick())));
            event.getPoseStack().m_252781_(Axis.f_252529_.m_252977_(plane.f_19860_ + (plane.m_146909_() - plane.f_19860_) * event.getPartialTick()));
            List passengers = plane.m_20197_();
            int i = passengers.indexOf(player);
            if (i >= 0) {
                Vec3 offset = plane.getPlayerOffsets()[i];
                offset = offset.m_82496_((float)(-Math.toRadians(plane.m_146909_())));
                event.getPoseStack().m_85837_(0.0, offset.f_82480_, 0.0);
            }
            event.getPoseStack().m_85841_(plane.getPlayerScaleFactor(), plane.getPlayerScaleFactor(), plane.getPlayerScaleFactor());
            event.getPoseStack().m_252880_(0.0f, (player.m_20206_() - player.m_20206_() * plane.getPlayerScaleFactor()) / 1.5f + (float)plane.getPlayerOffsets()[0].f_82480_, 0.0f);
            event.getPoseStack().m_252781_(Axis.f_252436_.m_252977_(plane.f_19859_ + (plane.m_146908_() - plane.f_19859_) * event.getPartialTick()));
        }
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post event) {
        if (event.getEntity().m_20202_() instanceof EntityPlaneSoundBase) {
            event.getPoseStack().m_85849_();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (!evt.player.equals((Object)this.mc.f_91074_)) {
            return;
        }
        EntityPlaneSoundBase vehicle = this.getPlane();
        if (vehicle != null && evt.player.equals((Object)vehicle.getDriver())) {
            this.cachedRelativeHeight = this.getRelativeHeight(vehicle);
        }
        if (vehicle != null && this.lastVehicle == null) {
            this.mc.f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
        } else if (vehicle == null && this.lastVehicle != null) {
            this.mc.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
        this.lastVehicle = vehicle;
    }

    private EntityPlaneSoundBase getPlane() {
        if (this.mc.f_91074_.m_20202_() instanceof EntityPlaneSoundBase) {
            return (EntityPlaneSoundBase)this.mc.f_91074_.m_20202_();
        }
        return null;
    }
}

