/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.DamageSourcePlane;
import de.maxhenkel.plane.entity.EntityPlaneBase;
import de.maxhenkel.plane.entity.EntityPlaneInventoryBase;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.item.ModItems;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public abstract class EntityPlaneDamageBase
extends EntityPlaneBase {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(EntityPlaneDamageBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final BlockingQueue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();

    public EntityPlaneDamageBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void m_8119_() {
        Runnable task;
        super.m_8119_();
        while ((task = (Runnable)this.tasks.poll()) != null) {
            task.run();
        }
        if (this.m_20077_()) {
            this.setPlaneDamage(this.getPlaneDamage() + 1.0f);
        }
        this.handleParticles();
    }

    protected void handleParticles() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        if (!((EntityPlaneSoundBase)this).isStarted()) {
            return;
        }
        float damage = this.getPlaneDamage();
        float chance = Math.max(damage - 25.0f, 0.0f) / 100.0f;
        if (this.f_19796_.m_188501_() < chance) {
            Vec3 lookVec = this.m_20154_().m_82541_().m_82490_(1.5);
            this.spawnParticle((ParticleOptions)ParticleTypes.f_123755_, lookVec.f_82479_, lookVec.f_82480_, lookVec.f_82481_);
        }
    }

    private void spawnParticle(ParticleOptions particleTypes, double offX, double offY, double offZ, double rand) {
        this.m_9236_().m_7106_(particleTypes, this.m_20185_() + offX + (this.f_19796_.m_188500_() * rand - rand / 2.0), this.m_20186_() + (double)this.m_20206_() / 2.0 + offY + (this.f_19796_.m_188500_() * rand - rand / 2.0), this.m_20189_() + offZ + (this.f_19796_.m_188500_() * rand - rand / 2.0), 0.0, 0.0, 0.0);
    }

    private void spawnParticle(ParticleOptions particleTypes, double offX, double offY, double offZ) {
        this.spawnParticle(particleTypes, offX, offY, offZ, 1.0);
    }

    @Override
    public void damagePlane(double damage, boolean horizontal) {
        super.damagePlane(damage, horizontal);
        this.setPlaneDamage((float)((double)this.getPlaneDamage() + damage));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_20147_()) {
            return false;
        }
        if (this.m_9236_().f_46443_ || !this.m_6084_()) {
            return false;
        }
        if (!(source.m_7640_() instanceof Player)) {
            return false;
        }
        Player player = (Player)source.m_7640_();
        if (player == null) {
            return false;
        }
        if (this.m_20363_((Entity)player)) {
            return false;
        }
        if (player.m_150110_().f_35937_ && player.m_6144_()) {
            this.destroyPlane(source, player);
            return true;
        }
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_().equals(ModItems.WRENCH.get()) && heldItem.m_41776_() - heldItem.m_41773_() >= 512) {
            heldItem.m_41622_(512, (LivingEntity)player, playerEntity -> {});
            this.destroyPlane(source, player);
        }
        return false;
    }

    public void destroyPlane(DamageSource source, Player player) {
        Container inventory = ((EntityPlaneInventoryBase)this).getInventory();
        Containers.m_19002_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (Container)inventory);
        inventory.m_6211_();
        LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(this.getLootTable());
        LootParams.Builder context = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81457_, (Object)source).m_287286_(LootContextParams.f_81458_, (Object)player).m_287286_(LootContextParams.f_81459_, (Object)player);
        loottable.m_287195_(context.m_287235_(LootContextParamSets.f_81415_)).forEach(arg_0 -> ((EntityPlaneDamageBase)this).m_19983_(arg_0));
        this.m_6074_();
    }

    public abstract ResourceLocation getLootTable();

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public float getPlaneDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setPlaneDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    @Override
    public boolean m_7337_(Entity entity) {
        double speed;
        if (!this.m_9236_().f_46443_ && entity instanceof LivingEntity && !this.m_20197_().contains(entity) && entity.m_20191_().m_82381_(this.m_20191_()) && (speed = this.m_20184_().m_82553_()) > (double)0.35f) {
            float damage = Math.min((float)(speed * 10.0), 15.0f);
            this.tasks.add(() -> {
                ServerLevel serverLevel = (ServerLevel)this.m_9236_();
                Optional holder = serverLevel.m_9598_().m_175515_(Registries.f_268580_).m_203636_(DamageSourcePlane.DAMAGE_PLANE_TYPE);
                holder.ifPresent(damageTypeReference -> entity.m_6469_(new DamageSource((Holder)damageTypeReference, (Entity)this), damage));
            });
        }
        return super.m_7337_(entity);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setPlaneDamage(compound.m_128457_("Damage"));
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Damage", this.getPlaneDamage());
    }
}

