/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.Main;
import de.maxhenkel.plane.entity.EntityPlaneDamageBase;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.net.MessageControlPlane;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class EntityPlaneControlBase
extends EntityPlaneDamageBase {
    private static final EntityDataAccessor<Float> ENGINE_SPEED = SynchedEntityData.m_135353_(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> STARTED = SynchedEntityData.m_135353_(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> START_TIME = SynchedEntityData.m_135353_(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> THRUST_POSITIVE = SynchedEntityData.m_135353_(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> THRUST_NEGATIVE = SynchedEntityData.m_135353_(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEFT = SynchedEntityData.m_135353_(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT = SynchedEntityData.m_135353_(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> UP = SynchedEntityData.m_135353_(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DOWN = SynchedEntityData.m_135353_(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BRAKE = SynchedEntityData.m_135353_(EntityPlaneControlBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final double MAX_ENGINE_SPEED = 1.5;
    public static final double ENGINE_ACCELERATION = 0.005;
    public static final double BRAKE_POWER = 0.012;
    private boolean onGroundLast;
    private boolean onGroundLast2;

    public EntityPlaneControlBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getStartTime() > this.getTimeToStart() && !this.isStarted() && this.canEngineBeStarted()) {
            this.setStarted(true);
        }
        if (this.isStarted() && !this.canEngineBeStarted()) {
            this.setStarted(false);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isStarted()) {
                if (this.isThrustPositive()) {
                    this.setEngineSpeed(Math.min(this.getEngineSpeed() + 0.025f, 1.0f));
                } else if (this.isThrustNegative()) {
                    this.setEngineSpeed(Math.max(this.getEngineSpeed() - 0.025f, 0.0f));
                }
            } else {
                this.setEngineSpeed(0.0f);
            }
        }
        this.controlPlane();
        this.handleRotation();
    }

    public boolean canEngineBeStarted() {
        return !this.isStarted() || !(this.getPlaneDamage() >= 100.0f);
    }

    public int getTimeToStart() {
        int time = 40;
        time = (int)((float)time + (float)((int)this.getPlaneDamage()) / 2.0f);
        return time;
    }

    private void handleRotation() {
        double speed = this.m_20184_().m_82553_();
        float rotationSpeed = 0.0f;
        if (Math.abs(speed) > 0.0) {
            rotationSpeed = Mth.m_14154_((float)(0.5f / (float)Math.pow(speed, 2.0)));
            rotationSpeed = Mth.m_14036_((float)rotationSpeed, (float)1.0f, (float)5.0f);
        }
        this.deltaRotation = 0.0f;
        rotationSpeed = Math.abs(rotationSpeed);
        if (this.isLeft()) {
            this.deltaRotation -= rotationSpeed;
        }
        if (this.isRight()) {
            this.deltaRotation += rotationSpeed;
        }
        this.m_146922_(this.m_146908_() + this.deltaRotation);
        float delta = Math.abs(this.m_146908_() - this.f_19859_);
        while (this.m_146908_() > 180.0f) {
            this.m_146922_(this.m_146908_() - 360.0f);
            this.f_19859_ = this.m_146908_() - delta;
        }
        while (this.m_146908_() <= -180.0f) {
            this.m_146922_(this.m_146908_() + 360.0f);
            this.f_19859_ = delta + this.m_146908_();
        }
        if (this.isUp()) {
            this.m_146926_(this.m_146909_() - 1.0f);
        } else if (this.isDown()) {
            this.m_146926_(this.m_146909_() + 1.0f);
        }
        this.m_146926_(Math.max(this.m_146909_(), -90.0f));
        this.m_146926_(Math.min(this.m_146909_(), 90.0f));
        float groundPitchTolerance = 7.0f;
        if (this.isCollidedVertical()) {
            if (this.m_146909_() > 0.0f) {
                this.m_146926_(this.m_146909_() - 10.0f);
                if (this.m_146909_() < 0.0f) {
                    this.m_146926_(0.0f);
                }
            }
            if (this.m_146909_() < -groundPitchTolerance) {
                this.m_146926_(this.m_146909_() + 10.0f);
                if (this.m_146909_() > -groundPitchTolerance) {
                    this.m_146926_(this.m_146909_() - groundPitchTolerance);
                }
            }
        }
    }

    private void controlPlane() {
        double newVerticalMotion;
        double damage;
        double newHorizontalMotion;
        double motionDifference;
        double damage2;
        if (!this.m_20160_()) {
            this.setThrustPositive(false);
            this.setThrustNegative(false);
            this.setLeft(false);
            this.setRight(false);
            this.setUp(false);
            this.setDown(false);
            this.setBrake(true);
            this.setStartTime(0);
        }
        Vec3 motionVector = this.m_20184_();
        double verticalMotion = Math.abs(motionVector.f_82480_);
        double horizontalMotion = this.getHorizontalMotion(motionVector);
        float engineSpeed = this.getEngineSpeed();
        if (this.isCollidedVertical()) {
            double maxEngineSpeed;
            double speed = this.m_20184_().m_82553_();
            if (speed < (maxEngineSpeed = 1.5 * (double)engineSpeed)) {
                speed = Math.min(speed + (double)engineSpeed * 0.005, maxEngineSpeed);
            }
            if (this.isBrake()) {
                speed = EntityPlaneControlBase.decreaseToZero(speed, 1.0 / (speed + 1.0) * 0.012);
            }
            if (engineSpeed <= 0.0f) {
                speed = EntityPlaneControlBase.decreaseToZero(speed, 0.002);
            }
            Vec3 motion = this.m_20154_().m_82541_().m_82490_(speed).m_82542_(1.0, 0.0, 1.0);
            this.m_20256_(motion);
            if (speed > 0.0) {
                this.m_6478_(MoverType.SELF, this.m_20184_());
            }
        } else {
            double speed;
            double fallSpeed = this.getFallSpeed();
            Vec3 lookVec = this.m_20154_();
            float modifiedPitch = (this.m_146909_() < 0.0f ? this.m_146909_() : Math.min(this.m_146909_() * 1.5f, 90.0f)) - 5.0f;
            float pitch = modifiedPitch * ((float)Math.PI / 180);
            double horizontalLook = Math.sqrt(lookVec.f_82479_ * lookVec.f_82479_ + lookVec.f_82481_ * lookVec.f_82481_);
            double lookLength = lookVec.m_82553_();
            float cosPitch = Mth.m_14089_((float)pitch);
            cosPitch = (float)((double)cosPitch * (double)cosPitch * Math.min(1.0, lookLength / 0.4));
            motionVector = this.m_20184_().m_82520_(0.0, fallSpeed * (-1.0 + (double)cosPitch * 0.75), 0.0);
            if (motionVector.f_82480_ < 0.0 && horizontalLook > 0.0) {
                double down = motionVector.f_82480_ * -0.1 * (double)cosPitch;
                motionVector = motionVector.m_82520_(lookVec.f_82479_ * down / horizontalLook, down, lookVec.f_82481_ * down / horizontalLook);
            }
            if (pitch < 0.0f && horizontalLook > 0.0) {
                double d13 = horizontalMotion * (double)(-Mth.m_14031_((float)pitch)) * 0.04;
                motionVector = motionVector.m_82520_(-lookVec.f_82479_ * d13 / horizontalLook, d13 * 3.2, -lookVec.f_82481_ * d13 / horizontalLook);
            }
            if (horizontalLook > 0.0) {
                motionVector = motionVector.m_82520_((lookVec.f_82479_ / horizontalLook * horizontalMotion - motionVector.f_82479_) * 0.1, 0.0, (lookVec.f_82481_ / horizontalLook * horizontalMotion - motionVector.f_82481_) * 0.1);
            }
            if ((speed = (motionVector = motionVector.m_82542_(0.99, 0.98, 0.99)).m_82553_()) < 1.5 * (double)engineSpeed) {
                double addSpeed = 0.0;
                if (speed + (addSpeed += (double)engineSpeed * 0.005 * 4.0) > 1.5 * (double)engineSpeed) {
                    addSpeed = 1.5 * (double)engineSpeed - speed;
                }
                if (addSpeed < 0.0) {
                    addSpeed = 0.0;
                }
                if (this.getPitchPercentage() < -0.25f) {
                    addSpeed = 0.0;
                }
                Vec3 addVec = this.m_20154_().m_82541_().m_82490_(addSpeed);
                motionVector = motionVector.m_82549_(new Vec3(addVec.f_82479_, 0.0, addVec.f_82481_));
            }
            if (this.isStalling(motionVector)) {
                motionVector = motionVector.m_82559_(new Vec3(0.975, 1.025, 0.975));
            }
            this.m_20256_(motionVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.isCollidedHorizontal() && (damage2 = (motionDifference = horizontalMotion - (newHorizontalMotion = this.getHorizontalMotion(this.m_20184_()))) * 1000.0 - 150.0) > 0.0) {
            this.damagePlane(damage2, true);
        }
        if (this.isCollidedVertical() && (damage = (motionDifference = verticalMotion - (newVerticalMotion = Math.abs(this.m_20184_().f_82480_))) * 1000.0 - 100.0) > 0.0) {
            this.damagePlane(damage, false);
        }
    }

    protected boolean isStalling(Vec3 motionVector) {
        return motionVector.m_82542_(1.0, 0.0, 1.0).m_82553_() / 4.0 < -motionVector.f_82480_;
    }

    public abstract double getFallSpeed();

    @Override
    public void damagePlane(double damage, boolean horizontal) {
        super.damagePlane(damage, horizontal);
        if (horizontal && damage > 5.0 || damage > 20.0) {
            this.setStarted(false);
        }
    }

    public boolean isCollidedVertical() {
        boolean last = this.onGroundLast;
        boolean last2 = this.onGroundLast2;
        this.onGroundLast2 = this.onGroundLast;
        this.onGroundLast = this.m_20096_();
        return last || last2 || this.m_20096_();
    }

    public boolean isCollidedHorizontal() {
        return this.f_19862_;
    }

    public double getHorizontalMotion(Vec3 vec3d) {
        return Math.sqrt(vec3d.f_82479_ * vec3d.f_82479_ + vec3d.f_82481_ * vec3d.f_82481_);
    }

    public double getAngle(Vec3 vec1, Vec3 vec2) {
        return Math.acos(Math.abs(vec1.m_82526_(vec2)) / (vec1.m_82553_() * vec2.m_82553_()));
    }

    private static double decreaseToZero(double num, double amount) {
        double erg;
        if (num < 0.0) {
            erg = num + amount;
            if (erg > 0.0) {
                erg = 0.0;
            }
        } else {
            erg = num - amount;
            if (erg < 0.0) {
                erg = 0.0;
            }
        }
        return erg;
    }

    public float getPitchPercentage() {
        return this.m_146909_() / 90.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STARTED, (Object)false);
        this.f_19804_.m_135372_(START_TIME, (Object)0);
        this.f_19804_.m_135372_(ENGINE_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(THRUST_POSITIVE, (Object)false);
        this.f_19804_.m_135372_(THRUST_NEGATIVE, (Object)false);
        this.f_19804_.m_135372_(LEFT, (Object)false);
        this.f_19804_.m_135372_(RIGHT, (Object)false);
        this.f_19804_.m_135372_(UP, (Object)false);
        this.f_19804_.m_135372_(DOWN, (Object)false);
        this.f_19804_.m_135372_(BRAKE, (Object)false);
    }

    public void updateControls(boolean up, boolean down, boolean thrustPos, boolean thrustNeg, boolean left, boolean right, boolean braking, boolean starting) {
        boolean needsUpdate = false;
        if (this.isThrustPositive() != thrustPos) {
            this.setThrustPositive(thrustPos);
            needsUpdate = true;
        }
        if (this.isThrustNegative() != thrustNeg) {
            this.setThrustNegative(thrustNeg);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.isUp() != up) {
            this.setUp(up);
            needsUpdate = true;
        }
        if (this.isDown() != down) {
            this.setDown(down);
            needsUpdate = true;
        }
        if (this.isBrake() != braking) {
            this.setBrake(braking);
            needsUpdate = true;
        }
        if (starting) {
            if (this.isStarted()) {
                if (this.getStartTime() <= 0) {
                    this.setStarted(false);
                }
            } else {
                this.setStartTime(this.getStartTime() + 1);
            }
            needsUpdate = true;
        } else if (this.getStartTime() > 0) {
            this.setStartTime(0);
            needsUpdate = true;
        }
        if (this.m_9236_().f_46443_ && needsUpdate) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageControlPlane(up, down, thrustPos, thrustNeg, left, right, braking, starting));
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("EngineSpeed", this.getEngineSpeed());
        compound.m_128379_("Started", this.isStarted());
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setEngineSpeed(compound.m_128457_("EngineSpeed"));
        ((EntityPlaneSoundBase)this).setStarted(compound.m_128471_("Started"), false);
    }

    public boolean isStarted() {
        return (Boolean)this.f_19804_.m_135370_(STARTED);
    }

    public void setStarted(boolean started) {
        this.f_19804_.m_135381_(STARTED, (Object)started);
    }

    public boolean isBrake() {
        return (Boolean)this.f_19804_.m_135370_(BRAKE);
    }

    public void setBrake(boolean breaking) {
        this.f_19804_.m_135381_(BRAKE, (Object)breaking);
    }

    public boolean isThrustPositive() {
        return (Boolean)this.f_19804_.m_135370_(THRUST_POSITIVE);
    }

    public void setThrustPositive(boolean thrustPositive) {
        this.f_19804_.m_135381_(THRUST_POSITIVE, (Object)thrustPositive);
    }

    public boolean isThrustNegative() {
        return (Boolean)this.f_19804_.m_135370_(THRUST_NEGATIVE);
    }

    public void setThrustNegative(boolean thrustNegative) {
        this.f_19804_.m_135381_(THRUST_NEGATIVE, (Object)thrustNegative);
    }

    public boolean isLeft() {
        return (Boolean)this.f_19804_.m_135370_(LEFT);
    }

    public void setLeft(boolean left) {
        this.f_19804_.m_135381_(LEFT, (Object)left);
    }

    public boolean isRight() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT);
    }

    public void setRight(boolean right) {
        this.f_19804_.m_135381_(RIGHT, (Object)right);
    }

    public boolean isUp() {
        return (Boolean)this.f_19804_.m_135370_(UP);
    }

    public void setUp(boolean up) {
        this.f_19804_.m_135381_(UP, (Object)up);
    }

    public boolean isDown() {
        return (Boolean)this.f_19804_.m_135370_(DOWN);
    }

    public void setDown(boolean down) {
        this.f_19804_.m_135381_(DOWN, (Object)down);
    }

    public float getEngineSpeed() {
        return ((Float)this.f_19804_.m_135370_(ENGINE_SPEED)).floatValue();
    }

    public void setEngineSpeed(float speed) {
        this.f_19804_.m_135381_(ENGINE_SPEED, (Object)Float.valueOf(speed));
    }

    public int getStartTime() {
        return (Integer)this.f_19804_.m_135370_(START_TIME);
    }

    public void setStartTime(int startTime) {
        this.f_19804_.m_135381_(START_TIME, (Object)startTime);
    }
}

