/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.gui.ContainerGasStation;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class GuiGasStation
extends ScreenBase<ContainerGasStation> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_gas_station.png");
    private TileEntityGasStation gasStation;
    private Inventory playerInventory;
    private static final int TITLE_COLOR = Color.WHITE.getRGB();
    private static final int FONT_COLOR = Color.DARK_GRAY.getRGB();
    protected Button buttonStart;
    protected Button buttonStop;

    public GuiGasStation(ContainerGasStation gasStation, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE, gasStation, playerInventory, title);
        this.gasStation = gasStation.getGasStation();
        this.playerInventory = playerInventory;
        this.f_97726_ = 176;
        this.f_97727_ = 217;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.buttonStart = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.car.start"), button -> {
            this.gasStation.setFueling(true);
            this.gasStation.sendStartFuelPacket(true);
        }).m_252987_(this.f_96543_ / 2 - 20, this.f_97736_ + 100, 40, 20).m_253136_());
        this.buttonStop = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.car.stop"), button -> {
            this.gasStation.setFueling(false);
            this.gasStation.sendStartFuelPacket(false);
        }).m_252987_(this.f_97735_ + this.f_97726_ - 40 - 7, this.f_97736_ + 100, 40, 20).m_253136_());
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        this.buttonStart.f_93623_ = !this.gasStation.isFueling();
        this.buttonStop.f_93623_ = this.gasStation.isFueling();
        guiGraphics.m_280137_(this.f_96547_, Component.m_237115_((String)"gui.gas_station").getString(), this.f_96543_ / 2, this.f_97736_ + 5, TITLE_COLOR);
        IFluidHandler fluidHandler = this.gasStation.getFluidHandlerInFront();
        if (fluidHandler instanceof Entity) {
            this.drawCarName(guiGraphics, (Entity)fluidHandler);
        }
        this.drawCarFuel(guiGraphics, fluidHandler);
        this.drawRefueled(guiGraphics);
        this.drawBuffer(guiGraphics);
        guiGraphics.m_280649_(this.f_96547_, this.playerInventory.m_5446_().m_7532_(), this.f_97735_ + 8, this.f_97736_ + this.f_97727_ - 93, FONT_COLOR, false);
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        ItemStack stack = this.gasStation.getTradingInventory().m_8020_(0);
        if (stack.m_41619_()) {
            return;
        }
        if (mouseX >= this.f_97735_ + 18 && mouseX <= this.f_97735_ + 33 && mouseY >= this.f_97736_ + 99 && mouseY <= this.f_97736_ + 114) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            list.add(Component.m_237110_((String)"tooltip.trade", (Object[])new Object[]{stack.m_41613_(), stack.m_41786_(), this.gasStation.getTradeAmount()}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    private void drawCarName(GuiGraphics guiGraphics, Entity entity) {
        String name = entity instanceof EntityGenericCar ? ((EntityGenericCar)entity).getShortName().getString() : entity.m_5446_().getString();
        guiGraphics.m_280649_(this.f_96547_, Component.m_237110_((String)"gas_station.car_info", (Object[])new Object[]{Component.m_237113_((String)name).m_130940_(ChatFormatting.WHITE)}).m_7532_(), this.f_97735_ + 63, this.f_97736_ + 20, FONT_COLOR, false);
    }

    private void drawCarFuel(GuiGraphics guiGraphics, IFluidHandler handler) {
        if (handler == null) {
            guiGraphics.m_280649_(this.f_96547_, Component.m_237115_((String)"gas_station.no_car").m_7532_(), this.f_97735_ + 63, this.f_97736_ + 30, FONT_COLOR, false);
            return;
        }
        if (handler.getTanks() <= 0) {
            guiGraphics.m_280649_(this.f_96547_, Component.m_237115_((String)"gas_station.fuel_empty").m_7532_(), this.f_97735_ + 63, this.f_97736_ + 30, FONT_COLOR, false);
            return;
        }
        FluidStack tank = handler.getFluidInTank(0);
        MutableComponent fuelText = Component.m_237110_((String)"gas_station.car_fuel_amount", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(tank.getAmount())).m_130940_(ChatFormatting.WHITE), Component.m_237113_((String)String.valueOf(handler.getTankCapacity(0))).m_130940_(ChatFormatting.WHITE)});
        guiGraphics.m_280649_(this.f_96547_, fuelText.m_7532_(), this.f_97735_ + 63, this.f_97736_ + 30, FONT_COLOR, false);
        if (!tank.isEmpty()) {
            guiGraphics.m_280649_(this.f_96547_, Component.m_237110_((String)"gas_station.car_fuel_type", (Object[])new Object[]{Component.m_237113_((String)tank.getDisplayName().getString()).m_130940_(ChatFormatting.WHITE)}).m_7532_(), this.f_97735_ + 63, this.f_97736_ + 40, FONT_COLOR, false);
        }
    }

    private void drawRefueled(GuiGraphics guiGraphics) {
        guiGraphics.m_280649_(this.f_96547_, Component.m_237110_((String)"gas_station.refueled", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.gasStation.getFuelCounter())).m_130940_(ChatFormatting.WHITE)}).m_7532_(), this.f_97735_ + 63, this.f_97736_ + 60, FONT_COLOR, false);
    }

    private void drawBuffer(GuiGraphics guiGraphics) {
        FluidStack stack = this.gasStation.getStorage();
        if (stack.isEmpty()) {
            guiGraphics.m_280649_(this.f_96547_, Component.m_237115_((String)"gas_station.fuel_empty").m_7532_(), this.f_97735_ + 63, this.f_97736_ + 70, FONT_COLOR, false);
            return;
        }
        int amount = this.gasStation.getFuelAmount();
        MutableComponent amountText = Component.m_237110_((String)"gas_station.fuel_buffer_amount", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(amount)).m_130940_(ChatFormatting.WHITE), Component.m_237113_((String)String.valueOf(this.gasStation.maxStorageAmount)).m_130940_(ChatFormatting.WHITE)});
        guiGraphics.m_280649_(this.f_96547_, amountText.m_7532_(), this.f_97735_ + 63, this.f_97736_ + 70, FONT_COLOR, false);
        MutableComponent bufferText = Component.m_237110_((String)"gas_station.fuel_buffer_type", (Object[])new Object[]{Component.m_237113_((String)stack.getDisplayName().getString()).m_130940_(ChatFormatting.WHITE)});
        guiGraphics.m_280649_(this.f_96547_, bufferText.m_7532_(), this.f_97735_ + 63, this.f_97736_ + 80, FONT_COLOR, false);
    }

    public boolean m_7043_() {
        return false;
    }
}

