/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.fluids;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;

public class FluidTypeCar
extends FluidType {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;

    public FluidTypeCar(String descriptionId, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        super(FluidType.Properties.create().canConvertToSource(false).canDrown(true).canExtinguish(false).canHydrate(false).canPushEntity(true).canSwim(true).lightLevel(0).supportsBoating(false).fallDistanceModifier(0.0f).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).descriptionId(descriptionId));
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation UNDERWATER_LOCATION = new ResourceLocation("textures/misc/underwater.png");
            private static final ResourceLocation WATER_OVERLAY = new ResourceLocation("block/water_overlay");

            public ResourceLocation getStillTexture() {
                return FluidTypeCar.this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return FluidTypeCar.this.flowingTexture;
            }

            public ResourceLocation getOverlayTexture() {
                return WATER_OVERLAY;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return UNDERWATER_LOCATION;
            }
        });
    }
}

