/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.net.MessageSyncTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityBase
extends BlockEntity
implements Nameable {
    private Component name;
    private CompoundTag compoundLast;

    public TileEntityBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void synchronize() {
        if (!this.f_58857_.f_46443_ && this.f_58857_ instanceof ServerLevel) {
            CompoundTag last = this.m_5995_();
            if (this.compoundLast == null || !this.compoundLast.equals((Object)last)) {
                Main.SIMPLE_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.m_58899_())), (Object)new MessageSyncTileEntity(this.f_58858_, last));
                this.compoundLast = last;
            }
        }
    }

    public void synchronize(int ticks) {
        if (this.f_58857_.m_46467_() % (long)ticks == 0L) {
            this.synchronize();
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.m_183515_(updateTag);
        return updateTag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public abstract Component getTranslatedName();

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component m_7755_() {
        return this.name != null ? this.name : this.getTranslatedName();
    }

    @javax.annotation.Nullable
    public Component m_7770_() {
        return this.name;
    }

    public abstract ContainerData getFields();

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.name != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("CustomName")) {
            this.name = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        super.m_142466_(compound);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this instanceof IFluidHandler && cap.equals((Object)ForgeCapabilities.FLUID_HANDLER) || this instanceof IEnergyStorage && cap.equals((Object)ForgeCapabilities.ENERGY)) {
            return LazyOptional.of(() -> this);
        }
        return LazyOptional.empty();
    }
}

