/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.api.gui.TextProvider;
import info.u_team.u_team_core.api.gui.TextSettingsProvider;
import info.u_team.u_team_core.api.gui.TextureProvider;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.api.gui.WidgetRenderable;
import info.u_team.u_team_core.util.FontUtil;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class WidgetUtil {
    private static final String ELLIPSIS = "...";

    public static <T extends AbstractWidget & BackgroundColorProvider> void renderWidget(T widget, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.enableDepthTest();
        ((WidgetRenderable)widget).renderWidgetTexture(guiGraphics, mouseX, mouseY, partialTick);
        ((PerspectiveRenderable)widget).renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        ((PerspectiveRenderable)widget).renderForeground(guiGraphics, mouseX, mouseY, partialTick);
        if (widget instanceof TooltipRenderable) {
            TooltipRenderable tooltipRenderable = (TooltipRenderable)widget;
            WidgetUtil.renderCustomTooltipForWidget(tooltipRenderable, guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public static <T extends AbstractWidget> void renderButtonLikeTexture(T widget, TextureProvider textureProvider, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RGBA color = WidgetUtil.respectWidgetAlpha(widget, ((BackgroundColorProvider)widget).getCurrentBackgroundColor(guiGraphics, mouseY, mouseY, partialTick));
        RenderUtil.drawContinuousTexturedBox(guiGraphics.m_280168_(), widget.m_252754_(), widget.m_252907_(), textureProvider.getU(), textureProvider.getV(), widget.m_5711_(), widget.m_93694_(), textureProvider.getWidth(), textureProvider.getHeight(), 2, 3, 2, 2, 0.0f, textureProvider.getTexture(), color);
    }

    public static <T extends AbstractWidget> void renderText(T widget, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float scale;
        Font font = ((TextSettingsProvider)widget).getCurrentTextFont();
        TextSettingsProvider.TextRenderType renderType = ((TextSettingsProvider)widget).getCurrentTextRenderType();
        Component message = ((TextProvider)widget).getCurrentText();
        RGBA color = WidgetUtil.respectWidgetAlpha(widget, ((TextSettingsProvider)widget).getCurrentTextColor(guiGraphics, mouseX, mouseY, partialTick));
        if (widget instanceof ScaleProvider) {
            ScaleProvider scaleProvider = (ScaleProvider)widget;
            scale = scaleProvider.getCurrentScale(guiGraphics, mouseY, mouseY, partialTick);
        } else {
            scale = 1.0f;
        }
        if (message == CommonComponents.f_237098_) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 0.0f);
        if (renderType == TextSettingsProvider.TextRenderType.ELLIPSIS) {
            WidgetUtil.renderTextWithCutoff(widget, font, message, color, scale, guiGraphics, mouseX, mouseY, partialTick);
        } else if (renderType == TextSettingsProvider.TextRenderType.SCROLLING) {
            WidgetUtil.renderTextWithScrolling(widget, font, message, color, scale, guiGraphics, mouseX, mouseY, partialTick);
        }
        poseStack.m_85849_();
    }

    private static void renderTextWithScrolling(AbstractWidget widget, Font font, Component message, RGBA color, float scale, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float positionFactor = 1.0f / scale;
        int maxWidth = widget.m_5711_() - 6;
        int messageWidth = Mth.m_14167_((float)(scale * (float)font.m_92852_((FormattedText)message)));
        float yStart = (float)(widget.m_252907_() + Mth.m_14167_((float)((float)widget.m_93694_() - 9.0f * scale)) / 2 + 1) * positionFactor;
        if (messageWidth > maxWidth) {
            int difference = messageWidth - maxWidth;
            double d0 = (double)Util.m_137550_() / 1000.0;
            double d1 = Math.max((double)difference * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.m_14139_((double)d2, (double)0.0, (double)difference);
            float xStart = (float)(widget.m_252754_() + 3 - (int)d3) * positionFactor;
            guiGraphics.m_280588_(widget.m_252754_() + 3, widget.m_252907_(), widget.m_252754_() + widget.m_5711_() - 3, widget.m_252907_() + widget.m_93694_());
            FontUtil.drawString(guiGraphics, font, message, xStart, yStart, color.getColorARGB(), true);
            guiGraphics.m_280618_();
        } else {
            float xStart = (float)(widget.m_252754_() + widget.m_5711_() / 2 - messageWidth / 2) * positionFactor;
            FontUtil.drawString(guiGraphics, font, message, xStart, yStart, color.getColorARGB(), true);
        }
    }

    private static void renderTextWithCutoff(AbstractWidget widget, Font font, Component message, RGBA color, float scale, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float positionFactor = 1.0f / scale;
        int maxWidth = widget.m_5711_() - 6;
        int messageWidth = Mth.m_14167_((float)(scale * (float)font.m_92852_((FormattedText)message)));
        int ellipsisWidth = Mth.m_14167_((float)(scale * (float)font.m_92895_(ELLIPSIS)));
        if (messageWidth > maxWidth && messageWidth > ellipsisWidth) {
            message = Component.m_237113_((String)(font.m_92854_((FormattedText)message, Mth.m_14143_((float)((float)maxWidth * positionFactor)) - ellipsisWidth).getString() + ELLIPSIS));
            messageWidth = maxWidth;
        }
        float xStart = (float)(widget.m_252754_() + widget.m_5711_() / 2 - messageWidth / 2) * positionFactor;
        float yStart = (float)(widget.m_252907_() + Mth.m_14167_((float)((float)widget.m_93694_() - 9.0f * scale)) / 2 + 1) * positionFactor;
        FontUtil.drawString(guiGraphics, font, message, xStart, yStart, color.getColorARGB(), true);
    }

    public static RGBA respectWidgetAlpha(AbstractWidget widget, RGBA color) {
        return color.setAlphaComponent(color.getAlphaComponent() * Mth.m_14036_((float)widget.f_93625_, (float)0.0f, (float)1.0f));
    }

    public static void renderCustomTooltipForWidget(TooltipRenderable renderable, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 400.0f);
        renderable.renderTooltip(guiGraphics, mouseX, mouseY, partialTick);
        poseStack.m_85849_();
    }
}

