/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import info.u_team.u_team_core.util.RGBA;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class RenderUtil {
    public static final RGBA DARK_CONTAINER_BORDER_COLOR = new RGBA(0x373737FF);
    public static final RGBA MEDIUM_CONTAINER_BORDER_COLOR = new RGBA(-1953788929);
    public static final RGBA BRIGHT_CONTAINER_BORDER_COLOR = RGBA.WHITE;

    public static void drawContainerBorder(PoseStack poseStack, int x, int y, int width, int height, float blitOffset, RGBA color) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderUtil.setShaderColor(color);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderUtil.addColoredQuad(bufferBuilder, poseStack, x, x + width - 1, y, y + 1, DARK_CONTAINER_BORDER_COLOR, blitOffset);
        RenderUtil.addColoredQuad(bufferBuilder, poseStack, x, x + 1, y, y + height - 1, DARK_CONTAINER_BORDER_COLOR, blitOffset);
        RenderUtil.addColoredQuad(bufferBuilder, poseStack, x + width - 1, x + width, y, y + 1, MEDIUM_CONTAINER_BORDER_COLOR, blitOffset);
        RenderUtil.addColoredQuad(bufferBuilder, poseStack, x, x + 1, y + height - 1, y + height, MEDIUM_CONTAINER_BORDER_COLOR, blitOffset);
        RenderUtil.addColoredQuad(bufferBuilder, poseStack, x + 1, x + width - 1, y + height - 1, y + height, BRIGHT_CONTAINER_BORDER_COLOR, blitOffset);
        RenderUtil.addColoredQuad(bufferBuilder, poseStack, x + width - 1, x + width, y + 1, y + height, BRIGHT_CONTAINER_BORDER_COLOR, blitOffset);
        tessellator.m_85914_();
        RenderSystem.disableBlend();
        RenderUtil.resetShaderColor();
    }

    public static void drawContinuousTexturedBox(PoseStack poseStack, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float blitOffset, ResourceLocation texture, RGBA color) {
        int index;
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderUtil.setShaderColor(color);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        RenderUtil.addTexturedRect(bufferBuilder, poseStack, x, y, u, v, 0.00390625f, 0.00390625f, leftBorder, topBorder, blitOffset);
        RenderUtil.addTexturedRect(bufferBuilder, poseStack, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, 0.00390625f, 0.00390625f, rightBorder, topBorder, blitOffset);
        RenderUtil.addTexturedRect(bufferBuilder, poseStack, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, 0.00390625f, 0.00390625f, leftBorder, bottomBorder, blitOffset);
        RenderUtil.addTexturedRect(bufferBuilder, poseStack, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, 0.00390625f, 0.00390625f, rightBorder, bottomBorder, blitOffset);
        for (index = 0; index < xPasses + (remainderWidth > 0 ? 1 : 0); ++index) {
            RenderUtil.addTexturedRect(bufferBuilder, poseStack, x + leftBorder + index * fillerWidth, y, u + leftBorder, v, 0.00390625f, 0.00390625f, index == xPasses ? remainderWidth : fillerWidth, topBorder, blitOffset);
            RenderUtil.addTexturedRect(bufferBuilder, poseStack, x + leftBorder + index * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, 0.00390625f, 0.00390625f, index == xPasses ? remainderWidth : fillerWidth, bottomBorder, blitOffset);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                RenderUtil.addTexturedRect(bufferBuilder, poseStack, x + leftBorder + index * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, 0.00390625f, 0.00390625f, index == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, blitOffset);
            }
        }
        for (index = 0; index < yPasses + (remainderHeight > 0 ? 1 : 0); ++index) {
            RenderUtil.addTexturedRect(bufferBuilder, poseStack, x, y + topBorder + index * fillerHeight, u, v + topBorder, 0.00390625f, 0.00390625f, leftBorder, index == yPasses ? remainderHeight : fillerHeight, blitOffset);
            RenderUtil.addTexturedRect(bufferBuilder, poseStack, x + leftBorder + canvasWidth, y + topBorder + index * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, 0.00390625f, 0.00390625f, rightBorder, index == yPasses ? remainderHeight : fillerHeight, blitOffset);
        }
        tessellator.m_85914_();
        RenderSystem.disableBlend();
        RenderUtil.resetShaderColor();
    }

    public static void drawTexturedQuad(PoseStack poseStack, int x, int y, int width, int height, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight, float blitOffset, ResourceLocation texture, RGBA color) {
        RenderUtil.drawTexturedQuad(poseStack, x, x + width, y, y + height, uOffset / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, vOffset / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight, blitOffset, texture, color);
    }

    public static void drawTexturedQuad(PoseStack poseStack, int x, int y, int width, int height, float blitOffset, TextureAtlasSprite sprite, RGBA color) {
        RenderUtil.drawTexturedQuad(poseStack, x, x + width, y, y + height, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), blitOffset, sprite.m_247685_(), color);
    }

    public static void drawTexturedQuad(PoseStack poseStack, int x1, int x2, int y1, int y2, float u1, float u2, float v1, float v2, float blitOffset, ResourceLocation texture, RGBA color) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderUtil.setShaderColor(color);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        RenderUtil.addTexturedQuad(bufferBuilder, poseStack, x1, x2, y1, y2, u1, u2, v1, v2, blitOffset);
        tessellator.m_85914_();
        RenderSystem.disableBlend();
        RenderUtil.resetShaderColor();
    }

    public static void addTexturedRect(BufferBuilder bufferBuilder, PoseStack poseStack, int x, int y, int u, int v, float uScale, float vScale, int width, int height, float blitOffset) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        bufferBuilder.m_252986_(matrix, (float)x, (float)(y + height), blitOffset).m_7421_((float)u * uScale, (float)(v + height) * vScale).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)(x + width), (float)(y + height), blitOffset).m_7421_((float)(u + width) * uScale, (float)(v + height) * vScale).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)(x + width), (float)y, blitOffset).m_7421_((float)(u + width) * uScale, (float)v * vScale).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x, (float)y, blitOffset).m_7421_((float)u * uScale, (float)v * vScale).m_5752_();
    }

    public static void addTexturedQuad(BufferBuilder bufferBuilder, PoseStack poseStack, int x1, int x2, int y1, int y2, float u1, float u2, float v1, float v2, float blitOffset) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        bufferBuilder.m_252986_(matrix, (float)x1, (float)y2, blitOffset).m_7421_(u1, v2).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x2, (float)y2, blitOffset).m_7421_(u2, v2).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x2, (float)y1, blitOffset).m_7421_(u2, v1).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x1, (float)y1, blitOffset).m_7421_(u1, v1).m_5752_();
    }

    public static void addColoredQuad(BufferBuilder bufferBuilder, PoseStack poseStack, int x1, int x2, int y1, int y2, RGBA color, float blitOffset) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        bufferBuilder.m_252986_(matrix, (float)x1, (float)y2, blitOffset).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x2, (float)y2, blitOffset).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x2, (float)y1, blitOffset).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x1, (float)y1, blitOffset).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
    }

    public static void addQuad(BufferBuilder bufferBuilder, PoseStack poseStack, int x1, int x2, int y1, int y2, float blitOffset) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        bufferBuilder.m_252986_(matrix, (float)x1, (float)y2, blitOffset).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x2, (float)y2, blitOffset).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x2, (float)y1, blitOffset).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x1, (float)y1, blitOffset).m_5752_();
    }

    public static void setShaderColor(RGBA rgba) {
        RenderSystem.setShaderColor((float)rgba.getRedComponent(), (float)rgba.getGreenComponent(), (float)rgba.getBlueComponent(), (float)rgba.getAlphaComponent());
    }

    public static void resetShaderColor() {
        RenderUtil.setShaderColor(RGBA.WHITE);
    }
}

