/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.init.network;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.menu.UContainerMenu;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record DataHolderMenuMessage(int containerId, int index, FriendlyByteBuf dataHolderBuffer) {
    public static void encode(DataHolderMenuMessage message, FriendlyByteBuf buffer) {
        buffer.writeByte(message.containerId);
        buffer.writeShort(message.index);
        buffer.m_130130_(message.dataHolderBuffer.readableBytes());
        buffer.writeBytes((ByteBuf)message.dataHolderBuffer);
        message.dataHolderBuffer.release();
    }

    public static DataHolderMenuMessage decode(FriendlyByteBuf buffer) {
        byte containerId = buffer.readByte();
        short index = buffer.readShort();
        FriendlyByteBuf dataHolderBuffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buffer.m_130052_()));
        return new DataHolderMenuMessage(containerId, index, dataHolderBuffer);
    }

    public static class Handler {
        public static void handle(DataHolderMenuMessage message, NetworkContext context) {
            context.executeOnMainThread(() -> {
                Handler.updateDataHolder(context.getPlayer().f_36096_, context.getEnvironment(), message);
                message.dataHolderBuffer.release();
            });
        }

        private static void updateDataHolder(AbstractContainerMenu menuToTest, NetworkEnvironment environment, DataHolderMenuMessage message) {
            Handler.testContainerMenu(menuToTest, message.containerId).ifPresent(menu -> menu.setDataHolder(environment, message.index, message.dataHolderBuffer));
        }

        private static Optional<UContainerMenu> testContainerMenu(AbstractContainerMenu menu, int containerId) {
            if (menu instanceof UContainerMenu) {
                UContainerMenu uContainer = (UContainerMenu)menu;
                if (menu.f_38840_ == containerId) {
                    return Optional.of(uContainer);
                }
            }
            return Optional.empty();
        }
    }
}

