/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.event.CommonEvents;
import info.u_team.u_team_core.util.registry.BusRegister;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegisterEvent;

public class ForgeCommonEventsHandler
implements CommonEvents.Handler {
    @Override
    public void registerSetup(CommonEvents.SetupEvent event, boolean forceMainThread) {
        this.registerModEvent(FMLCommonSetupEvent.class, modEvent -> {
            if (forceMainThread) {
                modEvent.enqueueWork(event::onSetup);
            } else {
                event.onSetup();
            }
        });
    }

    @Override
    public void registerRegister(CommonEvents.RegisterEvent event) {
        this.registerModEvent(RegisterEvent.class, modEvent -> event.onRegister(modEvent.getRegistryKey()));
    }

    @Override
    public void registerStartServerTick(CommonEvents.StartServerTick event) {
        this.registerForgeEvent(TickEvent.ServerTickEvent.class, forgeEvent -> {
            if (forgeEvent.phase == TickEvent.Phase.START) {
                event.onStartTick(forgeEvent.getServer());
            }
        });
    }

    @Override
    public void registerEndServerTick(CommonEvents.EndServerTick event) {
        this.registerForgeEvent(TickEvent.ServerTickEvent.class, forgeEvent -> {
            if (forgeEvent.phase == TickEvent.Phase.END) {
                event.onEndTick(forgeEvent.getServer());
            }
        });
    }

    @Override
    public void registerStartLevelTick(CommonEvents.StartLevelTick event) {
        this.registerForgeEvent(TickEvent.LevelTickEvent.class, forgeEvent -> {
            Level patt2427$temp;
            if (forgeEvent.phase == TickEvent.Phase.START && (patt2427$temp = forgeEvent.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt2427$temp;
                event.onStartTick(serverLevel);
            }
        });
    }

    @Override
    public void registerEndLevelTick(CommonEvents.EndLevelTick event) {
        this.registerForgeEvent(TickEvent.LevelTickEvent.class, forgeEvent -> {
            Level patt2709$temp;
            if (forgeEvent.phase == TickEvent.Phase.END && (patt2709$temp = forgeEvent.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt2709$temp;
                event.onEndTick(serverLevel);
            }
        });
    }

    @Override
    public void registerLevelLoad(CommonEvents.LevelLoad event) {
        this.registerForgeEvent(LevelEvent.Load.class, forgeEvent -> {
            LevelAccessor patt2956$temp = forgeEvent.getLevel();
            if (patt2956$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt2956$temp;
                event.onLoad(serverLevel);
            }
        });
    }

    @Override
    public void registerLevelUnload(CommonEvents.LevelUnload event) {
        this.registerForgeEvent(LevelEvent.Unload.class, forgeEvent -> {
            LevelAccessor patt3206$temp = forgeEvent.getLevel();
            if (patt3206$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt3206$temp;
                event.onUnload(serverLevel);
            }
        });
    }

    private <T extends Event> void registerModEvent(Class<T> eventClass, Consumer<T> event) {
        BusRegister.registerMod(bus -> bus.addListener(EventPriority.NORMAL, false, eventClass, event));
    }

    private <T extends Event> void registerForgeEvent(Class<T> eventClass, Consumer<T> event) {
        BusRegister.registerForge(bus -> bus.addListener(EventPriority.NORMAL, false, eventClass, event));
    }
}

