/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.u_team_core.api.gui.Scalable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.gui.elements.UEditBox;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class ScalableEditBox
extends UEditBox
implements Scalable,
ScaleProvider {
    protected float scale;

    public ScalableEditBox(Font font, int x, int y, int width, int height, UEditBox previousEditBox, Component title, float scale) {
        super(font, x, y, width, height, previousEditBox, title);
        this.scale = scale;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float currentScale = this.getCurrentScale(guiGraphics, mouseX, mouseY, partialTick);
        float positionFactor = 1.0f / this.scale;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(currentScale, currentScale, 0.0f);
        RGBA currentTextColor = WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentTextColor(guiGraphics, mouseX, mouseY, partialTick));
        String currentText = this.f_94092_.m_92834_(this.f_94093_.substring(this.f_94100_), (int)((float)this.m_94210_() * positionFactor));
        int cursorOffset = this.f_94101_ - this.f_94100_;
        int selectionOffset = Math.min(this.f_94102_ - this.f_94100_, currentText.length());
        boolean isCursorInText = cursorOffset >= 0 && cursorOffset <= currentText.length();
        boolean shouldCursorBlink = this.m_93696_() && this.f_94095_ / 6 % 2 == 0 && isCursorInText;
        boolean isCursorInTheMiddle = this.f_94101_ < this.f_94093_.length() || this.f_94093_.length() >= this.f_94094_;
        int xOffset = (int)((float)(this.f_94096_ ? this.f_93620_ + 4 : this.f_93620_) * positionFactor);
        int yOffset = (int)((this.f_94096_ ? (float)this.f_93621_ + ((float)this.f_93619_ - 8.0f * currentScale) / 2.0f : (float)this.f_93621_) * positionFactor);
        int leftRenderedTextX = xOffset;
        if (!currentText.isEmpty()) {
            String firstTextPart = isCursorInText ? currentText.substring(0, cursorOffset) : currentText;
            leftRenderedTextX = guiGraphics.m_280648_(this.f_94092_, (FormattedCharSequence)this.f_94091_.apply(firstTextPart, this.f_94100_), xOffset, yOffset, currentTextColor.getColorARGB());
        }
        int rightRenderedTextX = leftRenderedTextX;
        if (!isCursorInText) {
            rightRenderedTextX = cursorOffset > 0 ? (int)((float)xOffset + (float)this.f_93618_ * positionFactor) : xOffset;
        } else if (isCursorInTheMiddle) {
            rightRenderedTextX = leftRenderedTextX - 1;
            --leftRenderedTextX;
        }
        if (!currentText.isEmpty() && isCursorInText && cursorOffset < currentText.length()) {
            guiGraphics.m_280648_(this.f_94092_, (FormattedCharSequence)this.f_94091_.apply(currentText.substring(cursorOffset), this.f_94101_), leftRenderedTextX, yOffset, currentTextColor.getColorARGB());
        }
        if (this.f_256828_ != null && currentText.isEmpty() && !this.m_93696_()) {
            guiGraphics.m_280430_(this.f_94092_, this.f_256828_, leftRenderedTextX, yOffset, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentHintTextColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
        }
        if (!isCursorInTheMiddle && this.f_94088_ != null) {
            guiGraphics.m_280488_(this.f_94092_, this.f_94088_, rightRenderedTextX - 1, yOffset, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentSuggestionTextColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
        }
        if (shouldCursorBlink) {
            if (isCursorInTheMiddle) {
                guiGraphics.m_280509_(rightRenderedTextX, yOffset - 1, rightRenderedTextX + 1, yOffset + 1 + 9, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentCursorColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
            } else {
                guiGraphics.m_280488_(this.f_94092_, "_", rightRenderedTextX, yOffset, currentTextColor.getColorARGB());
            }
        }
        poseStack.m_85849_();
        if (selectionOffset != cursorOffset) {
            int selectedX = xOffset + this.f_94092_.m_92895_(currentText.substring(0, selectionOffset));
            this.m_264315_(guiGraphics, (int)((float)rightRenderedTextX * currentScale), (int)((float)(yOffset - 1) * currentScale), (int)((float)(selectedX - 1) * currentScale), (int)((float)(yOffset + 1 + 9) * currentScale));
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.f_93623_ && this.f_93624_ && this.m_7972_(button)) {
            boolean clicked = this.m_93680_(mouseX, mouseY);
            if (this.f_94097_) {
                this.m_93692_(clicked);
            }
            if (this.m_93696_() && clicked) {
                int clickOffset = Mth.m_14107_((double)mouseX) - this.f_93620_;
                if (this.f_94096_) {
                    clickOffset -= 4;
                }
                clickOffset = (int)((float)clickOffset / this.getCurrentScale());
                String currentText = this.f_94092_.m_92834_(this.f_94093_.substring(this.f_94100_), (int)((float)(this.m_94210_() * 1) / this.getCurrentScale()));
                this.m_94192_(this.f_94092_.m_92834_(currentText, clickOffset).length() + this.f_94100_);
                return true;
            }
        }
        return false;
    }

    public void m_94208_(int position) {
        int valueLength = this.f_94093_.length();
        this.f_94102_ = Mth.m_14045_((int)position, (int)0, (int)valueLength);
        if (this.f_94092_ != null) {
            if (this.f_94100_ > valueLength) {
                this.f_94100_ = valueLength;
            }
            int scaledInnerWidth = (int)((float)(this.m_94210_() * 1) / this.getCurrentScale());
            String currentText = this.f_94092_.m_92834_(this.f_94093_.substring(this.f_94100_), scaledInnerWidth);
            int offset = currentText.length() + this.f_94100_;
            if (this.f_94102_ == this.f_94100_) {
                this.f_94100_ -= this.f_94092_.m_92837_(this.f_94093_, scaledInnerWidth, true).length();
            }
            if (this.f_94102_ > offset) {
                this.f_94100_ += this.f_94102_ - offset;
            } else if (this.f_94102_ <= this.f_94100_) {
                this.f_94100_ -= this.f_94100_ - this.f_94102_;
            }
            this.f_94100_ = Mth.m_14045_((int)this.f_94100_, (int)0, (int)valueLength);
        }
    }

    @Override
    public float getCurrentScale(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.getCurrentScale();
    }

    public float getCurrentScale() {
        return this.scale;
    }
}

