/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import info.u_team.u_team_core.data.CommonDataProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class CommonRecipeProvider
implements DataProvider,
CommonDataProvider<Consumer<FinishedRecipe>> {
    private final GenerationData generationData;
    private final PackOutput.PathProvider recipePathProvider;
    private final PackOutput.PathProvider advancementPathProvider;

    public CommonRecipeProvider(GenerationData generationData) {
        this.generationData = generationData;
        this.recipePathProvider = generationData.output().m_245269_(PackOutput.Target.DATA_PACK, "recipes");
        this.advancementPathProvider = generationData.output().m_245269_(PackOutput.Target.DATA_PACK, "advancements");
    }

    @Override
    public GenerationData getGenerationData() {
        return this.generationData;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        HashSet duplicates = Sets.newHashSet();
        ArrayList futures = new ArrayList();
        this.register(recipe -> this.generateRecipe(cache, (FinishedRecipe)recipe, duplicates, false, futures));
        this.registerVanilla(recipe -> this.generateRecipe(cache, (FinishedRecipe)recipe, duplicates, true, futures));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "Recipe";
    }

    public void registerVanilla(Consumer<FinishedRecipe> consumer) {
    }

    private void generateRecipe(CachedOutput cache, FinishedRecipe recipe, Set<ResourceLocation> duplicates, boolean vanillaAdvancements, List<CompletableFuture<?>> futures) {
        ResourceLocation recipeLocation = recipe.m_6445_();
        if (!duplicates.add(recipeLocation)) {
            throw new IllegalStateException("Duplicate recipe " + recipeLocation);
        }
        futures.add(CommonDataProvider.saveData(cache, (JsonElement)recipe.m_125966_(), this.recipePathProvider.m_245731_(recipeLocation)));
        JsonObject advancementJson = recipe.m_5860_();
        if (advancementJson != null) {
            ResourceLocation advancementLocation = vanillaAdvancements ? recipe.m_6448_() : new ResourceLocation(recipeLocation.m_135827_(), "recipes/" + recipeLocation.m_135815_());
            futures.add(CommonDataProvider.saveData(cache, (JsonElement)advancementJson, this.advancementPathProvider.m_245731_(advancementLocation)));
        }
    }

    protected InventoryChangeTrigger.TriggerInstance has(TagKey<Item> tag) {
        return this.has(ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_());
    }

    protected InventoryChangeTrigger.TriggerInstance has(ItemLike item) {
        return this.has(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
    }

    protected InventoryChangeTrigger.TriggerInstance has(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, predicates);
    }

    public static Ingredient getIngredientOfTag(TagKey<Item> tag) {
        return Ingredient.m_204132_(tag);
    }
}

