/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.ai.EntityAIWanderNotLazy;
import net.tropicraft.core.common.entity.egg.TropiSpiderEggEntity;

public class TropiSpiderEntity
extends Spider {
    private static final EntityDataAccessor<Byte> TYPE = SynchedEntityData.m_135353_(TropiSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int SPIDER_MATURE_AGE = 12000;
    private static final int SPIDER_MAX_EGGS = 10;
    private static final long SPIDER_MIN_EGG_DELAY = 12000L;
    private static final int SPIDER_EGG_CHANCE = 1000;
    private BlockPos nestSite;
    private TropiSpiderEntity mother = null;
    private long ticksSinceLastEgg = 0L;
    public byte initialType = 0;
    private boolean jumping;

    public TropiSpiderEntity(EntityType<? extends Spider> type, Level world) {
        super(type, world);
        this.f_19797_ = 12000;
        this.ticksSinceLastEgg = this.f_19797_;
    }

    public static TropiSpiderEntity haveBaby(TropiSpiderEntity mother) {
        TropiSpiderEntity baby = new TropiSpiderEntity((EntityType<? extends Spider>)((EntityType)TropicraftEntities.TROPI_SPIDER.get()), mother.m_9236_());
        baby.setSpiderType(Type.CHILD);
        baby.f_19797_ = 0;
        baby.mother = mother;
        return baby;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)this.initialType);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.8, false));
        this.f_21345_.m_25352_(7, (Goal)new EntityAIWanderNotLazy((PathfinderMob)this, 0.8, 40));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        if (damageSrc.m_7639_() != null && damageSrc.m_7639_() instanceof LivingEntity) {
            this.m_6710_((LivingEntity)damageSrc.m_7639_());
        }
        super.m_6475_(damageSrc, damageAmount);
    }

    public boolean m_6147_() {
        return this.m_33816_() && this.m_21573_().m_26571_();
    }

    public boolean m_33816_() {
        return this.f_19862_;
    }

    protected float m_274460_() {
        return this.jumping ? 0.3f : 0.2f;
    }

    public void m_8119_() {
        this.f_19789_ = 0.0f;
        super.m_8119_();
        LivingEntity attackTarget = this.m_5448_();
        if (attackTarget != null && this.m_20280_((Entity)attackTarget) < 128.0) {
            Util.tryMoveToEntityLivingLongDist((Mob)this, (Entity)attackTarget, 0.8f);
        }
        if (!this.m_9236_().f_46443_ && attackTarget != null && this.m_20096_() && this.f_19796_.m_188503_(3) == 0 && attackTarget.m_20270_((Entity)this) < 5.0f) {
            this.m_21573_().m_26573_();
            this.m_6135_();
            this.jumping = true;
        } else {
            this.jumping = false;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.getSpiderType() == Type.CHILD) {
                if (this.f_19797_ >= 12000) {
                    this.setSpiderType(Type.ADULT);
                }
                if (this.mother != null) {
                    if (this.m_20280_((Entity)this.mother) > 16.0) {
                        Util.tryMoveToEntityLivingLongDist((Mob)this, (Entity)this.mother, 0.8f);
                    } else {
                        this.m_21573_().m_26573_();
                    }
                    if (this.mother.m_5448_() != null) {
                        this.m_6710_(this.mother.m_5448_());
                    }
                }
            }
            if (this.getSpiderType() == Type.ADULT) {
                if (this.mother != null) {
                    if (!this.mother.m_6084_()) {
                        this.mother = null;
                        this.m_21573_().m_26573_();
                        this.m_6710_(null);
                    }
                    this.m_6710_((LivingEntity)this.mother);
                }
                if (this.f_19796_.m_188503_(1000) == 0 && this.ticksSinceLastEgg > 12000L && this.f_19797_ % 80 == 0) {
                    this.buildNest();
                }
            }
            if (this.getSpiderType() == Type.MOTHER && this.nestSite != null) {
                if (this.ticksSinceLastEgg < 2000L) {
                    if (!this.m_20183_().m_123314_((Vec3i)this.nestSite, 16.0)) {
                        Util.tryMoveToXYZLongDist((Mob)this, this.nestSite, 0.9f);
                    }
                } else {
                    this.nestSite = null;
                }
            }
            ++this.ticksSinceLastEgg;
        }
    }

    protected SoundEvent m_7515_() {
        return this.f_19796_.m_188503_(20) == 0 ? super.m_7515_() : null;
    }

    protected void m_7355_(BlockPos pos, BlockState blockState) {
        if (this.getSpiderType() == Type.CHILD) {
            if (this.f_19796_.m_188503_(20) == 0) {
                super.m_7355_(pos, blockState);
            }
        } else {
            super.m_7355_(pos, blockState);
        }
    }

    public boolean m_6094_() {
        return this.getSpiderType() != Type.MOTHER;
    }

    public void buildNest() {
        if (!this.m_9236_().f_46443_) {
            this.setSpiderType(Type.MOTHER);
            int r = this.f_19796_.m_188503_(10) + 1;
            if (r < 2) {
                return;
            }
            for (int i = 0; i < r; ++i) {
                TropiSpiderEggEntity egg = (TropiSpiderEggEntity)((EntityType)TropicraftEntities.TROPI_SPIDER_EGG.get()).m_20615_(this.m_9236_());
                egg.setMotherId(this.m_20148_());
                egg.m_6034_((float)this.m_20183_().m_123341_() + this.f_19796_.m_188501_(), this.m_20183_().m_123342_(), (float)this.m_20183_().m_123343_() + this.f_19796_.m_188501_());
                this.m_9236_().m_7967_((Entity)egg);
                this.ticksSinceLastEgg = 0L;
            }
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    if (this.f_19796_.m_188503_(8) != 0) continue;
                    BlockPos pos = new BlockPos(this.m_20183_().m_123341_() - 2 + x, this.m_20183_().m_123342_(), this.m_20183_().m_123343_() - 2 + z);
                    if (!this.m_9236_().m_46859_(pos) || !this.m_9236_().m_8055_(pos.m_7495_()).m_280296_()) continue;
                    this.m_9236_().m_46597_(pos, Blocks.f_50033_.m_49966_());
                }
            }
            this.nestSite = this.m_20183_();
        }
    }

    public void m_7380_(CompoundTag n) {
        n.m_128405_("ticks", this.f_19797_);
        n.m_128344_("spiderType", (byte)this.getSpiderType().ordinal());
        n.m_128356_("timeSinceLastEgg", this.ticksSinceLastEgg);
        super.m_7380_(n);
    }

    public void m_7378_(CompoundTag n) {
        this.f_19797_ = n.m_128451_("ticks");
        this.setSpiderType(n.m_128445_("spiderType"));
        this.ticksSinceLastEgg = n.m_128454_("timeSinceLastEgg");
        super.m_7378_(n);
    }

    public Type getSpiderType() {
        return Type.VALUES[(Byte)this.m_20088_().m_135370_(TYPE)];
    }

    public void setSpiderType(Type type) {
        this.m_20088_().m_135381_(TYPE, (Object)((byte)type.ordinal()));
        this.m_6210_();
    }

    public void setSpiderType(byte b) {
        this.m_20088_().m_135381_(TYPE, (Object)b);
        this.m_6210_();
    }

    public static enum Type {
        ADULT,
        MOTHER,
        CHILD;

        private static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

