/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.TropiCreeperModel;
import net.tropicraft.core.common.entity.passive.TropiCreeperEntity;

@OnlyIn(value=Dist.CLIENT)
public class TropiCreeperRenderer
extends MobRenderer<TropiCreeperEntity, TropiCreeperModel> {
    private static final ResourceLocation CREEPER_TEXTURE = new ResourceLocation("tropicraft", "textures/entity/tropicreeper.png");

    public TropiCreeperRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new TropiCreeperModel(context.m_174023_(TropicraftRenderLayers.TROPI_CREEPER_LAYER)), 0.5f);
    }

    protected void scale(TropiCreeperEntity entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        float f = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        float f1 = 1.0f + Mth.m_14031_((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        matrixStackIn.m_85841_(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(TropiCreeperEntity livingEntityIn, float partialTicks) {
        float f = livingEntityIn.getCreeperFlashIntensity(partialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.m_14036_((float)f, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(TropiCreeperEntity e) {
        return CREEPER_TEXTURE;
    }
}

