/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.common.entity.SeaTurtleEntity;
import net.tropicraft.core.common.entity.placeable.BeachFloatEntity;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tropicraft")
public class PlayerRotationHandler {
    private static float rotationYawHead;
    private static float prevRotationYawHead;
    private static float rotationPitch;
    private static float prevRotationPitch;

    private static float interpolateAndWrap(float cur, float prev, float partial) {
        return Mth.m_14177_((float)(prev + (cur - prev) * partial));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        PoseStack stack = event.getPoseStack();
        Player p = event.getEntity();
        Entity riding = p.m_20202_();
        float partialTick = event.getPartialTick();
        if (riding instanceof BeachFloatEntity) {
            BeachFloatEntity floaty = (BeachFloatEntity)riding;
            stack.m_85836_();
            stack.m_252781_(Axis.f_252436_.m_252977_(-(floaty.f_19859_ + partialTick * (floaty.m_146908_() - floaty.f_19859_))));
            stack.m_85837_(0.0, 1.55, 1.55);
            stack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
            float f = PlayerRotationHandler.interpolateAndWrap(p.f_20883_, p.f_20884_, partialTick);
            stack.m_252781_(Axis.f_252436_.m_252977_(f));
            rotationYawHead = p.f_20885_;
            prevRotationYawHead = p.f_20886_;
            p.f_20885_ = p.f_20883_;
            p.f_20886_ = p.f_20884_;
            rotationPitch = p.m_146909_();
            prevRotationPitch = p.f_19860_;
            p.m_146926_(10.0f);
            p.f_19860_ = 10.0f;
            p.f_267362_.m_267771_(0.0f);
            p.f_267362_.m_267566_(0.0f, 1.0f);
        }
        if (riding instanceof SeaTurtleEntity) {
            SeaTurtleEntity turtle = (SeaTurtleEntity)riding;
            stack.m_85836_();
            float pitch = PlayerRotationHandler.interpolateAndWrap(turtle.m_146909_(), turtle.f_19860_, partialTick);
            float yaw = PlayerRotationHandler.interpolateAndWrap(turtle.f_20885_, turtle.f_20886_, partialTick);
            stack.m_85837_(0.0, turtle.m_6048_() - p.m_6049_(), 0.0);
            stack.m_252781_(Axis.f_252392_.m_252977_(yaw));
            stack.m_85837_(0.0, -0.1, 0.0);
            stack.m_252781_(Axis.f_252529_.m_252977_(pitch));
            stack.m_85837_(0.0, 0.1, 0.0);
            stack.m_252781_(Axis.f_252436_.m_252977_(yaw));
            stack.m_85837_(0.0, -turtle.m_6048_() + p.m_6049_(), 0.0);
            Vec3 passengerOffset = new Vec3(-0.25, 0.0, 0.0).m_82524_((float)(-Math.toRadians(yaw) - 1.5707963267948966));
            stack.m_85837_(passengerOffset.m_7096_(), 0.0, passengerOffset.m_7094_());
            rotationPitch = p.m_146909_();
            prevRotationPitch = p.f_19860_;
            p.m_146926_(10.0f);
            p.f_19860_ = 10.0f;
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        Player p = event.getEntity();
        if (p.m_20202_() instanceof BeachFloatEntity || p.m_20202_() instanceof SeaTurtleEntity) {
            event.getPoseStack().m_85849_();
            p.m_146926_(rotationPitch);
            p.f_19860_ = prevRotationPitch;
        }
        if (p.m_20202_() instanceof BeachFloatEntity) {
            p.f_20885_ = rotationYawHead;
            p.f_20886_ = prevRotationYawHead;
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerSpecials(RenderNameTagEvent event) {
        if (event.getEntity().m_20202_() instanceof BeachFloatEntity) {
            event.setResult(Event.Result.DENY);
        }
    }
}

