/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;
import net.tropicraft.core.client.entity.model.EggModel;
import net.tropicraft.core.common.entity.egg.EggEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class EggRenderer
extends LivingEntityRenderer<EggEntity, EggModel> {
    public EggRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation) {
        super(context, (EntityModel)new EggModel(context.m_174023_(modelLayerLocation)), 1.0f);
        this.f_114478_ = 0.5f;
    }

    public void render(EggEntity egg, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        stack.m_85836_();
        if (egg.shouldEggRenderFlat()) {
            this.f_114477_ = 0.0f;
            stack.m_85837_(0.0, 0.05, 0.0);
            this.drawFlatEgg(egg, partialTicks, stack, bufferIn, packedLightIn);
        } else {
            this.f_114477_ = 0.2f;
            stack.m_85841_(0.5f, 0.5f, 0.5f);
            super.m_7392_((LivingEntity)egg, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        }
        stack.m_85849_();
    }

    public void drawFlatEgg(EggEntity ent, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        stack.m_85836_();
        stack.m_252781_(this.f_114476_.m_253208_());
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        stack.m_85841_(0.25f, 0.25f, 0.25f);
        VertexConsumer buffer = TropicraftRenderUtils.getEntityCutoutBuilder(bufferIn, this.getTextureLocation(ent));
        int overlay = EggRenderer.m_115338_((LivingEntity)ent, (float)this.m_6931_(ent, partialTicks));
        Matrix4f mat = stack.m_85850_().m_252922_();
        Matrix3f normal = new Matrix3f();
        TropicraftSpecialRenderHelper.vertex(buffer, mat, normal, -0.5, -0.25, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, Direction.UP, packedLightIn, overlay);
        TropicraftSpecialRenderHelper.vertex(buffer, mat, normal, 0.5, -0.25, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, Direction.UP, packedLightIn, overlay);
        TropicraftSpecialRenderHelper.vertex(buffer, mat, normal, 0.5, 0.75, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, Direction.UP, packedLightIn, overlay);
        TropicraftSpecialRenderHelper.vertex(buffer, mat, normal, -0.5, 0.75, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP, packedLightIn, overlay);
        stack.m_85849_();
    }

    protected boolean shouldShowName(EggEntity entity) {
        return entity.m_8077_();
    }

    public ResourceLocation getTextureLocation(EggEntity entity) {
        return TropicraftRenderUtils.bindTextureEntity(entity.getEggTexture());
    }
}

