/*
 * Decompiled with CFR 0.152.
 */
package mod.torchbowmod;

import mod.torchbowmod.TorchBowMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class EntityTorch
extends AbstractArrow {
    private EntityTorchMode state;

    public EntityTorch(PlayMessages.SpawnEntity packet, Level worldIn) {
        super((EntityType)TorchBowMod.entityTorch.get(), worldIn);
    }

    public EntityTorch(EntityType<? extends EntityTorch> p_i50172_1_, Level p_i50172_2_) {
        super(p_i50172_1_, p_i50172_2_);
    }

    public EntityTorch(Level worldIn, double x, double y, double z) {
        super((EntityType)TorchBowMod.entityTorch.get(), x, y, z, worldIn);
    }

    public EntityTorch(Level worldIn, LivingEntity shooter, EntityTorchMode mode) {
        super((EntityType)TorchBowMod.entityTorch.get(), shooter, worldIn);
        this.state = mode;
    }

    protected void m_5790_(EntityHitResult entityRayTraceResult) {
        super.m_5790_(entityRayTraceResult);
        Entity entity = entityRayTraceResult.m_82443_();
        entity.m_7311_(100);
    }

    protected void m_8060_(BlockHitResult raytraceResultIn) {
        super.m_8060_(raytraceResultIn);
        HitResult.Type raytraceresult$type = raytraceResultIn.m_6662_();
        if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.setTorch(raytraceResultIn, (HitResult)raytraceResultIn);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void setTorch(BlockHitResult blockraytraceresult, HitResult raytraceResultIn) {
        BlockPos blockpos = blockraytraceresult.m_82425_();
        if (!this.m_9236_().m_8055_(blockpos).m_60795_() && !this.m_9236_().f_46443_) {
            Direction face = ((BlockHitResult)raytraceResultIn).m_82434_();
            BlockState torch_state = Blocks.f_50082_.m_49966_();
            BlockPos setBlockPos = this.getPosOfFace(blockpos, face);
            if (this.isBlockAIR(setBlockPos)) {
                if (face == Direction.UP) {
                    torch_state = Blocks.f_50081_.m_49966_();
                    this.m_9236_().m_7731_(setBlockPos, torch_state, 3);
                    this.m_142687_(Entity.RemovalReason.KILLED);
                } else if (face == Direction.DOWN && TorchBowMod.CeilingTorch != null) {
                    BlockState ceiling_torch = TorchBowMod.CeilingTorch.m_49966_();
                    this.m_9236_().m_7731_(setBlockPos, ceiling_torch, 3);
                    this.m_142687_(Entity.RemovalReason.KILLED);
                } else if (face != Direction.DOWN) {
                    this.m_9236_().m_7731_(setBlockPos, (BlockState)torch_state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)face), 3);
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
            }
        }
    }

    private BlockPos getPosOfFace(BlockPos blockPos, Direction face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> blockPos.m_7494_();
            case Direction.EAST -> blockPos.m_122029_();
            case Direction.WEST -> blockPos.m_122024_();
            case Direction.SOUTH -> blockPos.m_122019_();
            case Direction.NORTH -> blockPos.m_122012_();
            case Direction.DOWN -> blockPos.m_7495_();
        };
    }

    private boolean isBlockAIR(BlockPos pos) {
        Block[] a;
        Block getBlock = this.m_9236_().m_8055_(pos).m_60734_();
        if (getBlock instanceof BushBlock) {
            return true;
        }
        for (Block traget : a = new Block[]{Blocks.f_50627_, Blocks.f_50016_, Blocks.f_50125_, Blocks.f_50191_}) {
            if (getBlock != traget) continue;
            return true;
        }
        return false;
    }

    protected ItemStack m_7941_() {
        if (this.state == EntityTorchMode.TORCH_STATE) {
            return new ItemStack((ItemLike)Blocks.f_50081_);
        }
        return new ItemStack((ItemLike)TorchBowMod.torchArrow.get());
    }

    static enum EntityTorchMode {
        TORCH_STATE,
        ARROW_STATE;

    }
}

