/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.logistics.filter.ItemAttribute;
import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.integration.create.BambooSpikesBehavior;
import net.mehvahdjukaar.supplementaries.integration.create.BlackboardDisplayTarget;
import net.mehvahdjukaar.supplementaries.integration.create.ClockDisplaySource;
import net.mehvahdjukaar.supplementaries.integration.create.FluidFillLevelDisplaySource;
import net.mehvahdjukaar.supplementaries.integration.create.GlobeDisplaySource;
import net.mehvahdjukaar.supplementaries.integration.create.HourglassBehavior;
import net.mehvahdjukaar.supplementaries.integration.create.ItemDisplayDisplaySource;
import net.mehvahdjukaar.supplementaries.integration.create.NoticeBoardDisplaySource;
import net.mehvahdjukaar.supplementaries.integration.create.NoticeBoardDisplayTarget;
import net.mehvahdjukaar.supplementaries.integration.create.PresentRecipientAttribute;
import net.mehvahdjukaar.supplementaries.integration.create.SpeakerBlockDisplayTarget;
import net.mehvahdjukaar.supplementaries.integration.create.TextHolderDisplayTarget;
import net.mehvahdjukaar.supplementaries.integration.forge.CreateCompatImpl;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;

public class CreateCompat {
    public static void setup() {
        try {
            ItemAttribute.register((ItemAttribute)PresentRecipientAttribute.EMPTY);
            AllMovementBehaviours.registerBehaviour((Block)ModRegistry.BAMBOO_SPIKES.get(), (MovementBehaviour)new BambooSpikesBehavior());
            AllMovementBehaviours.registerBehaviour((Block)ModRegistry.HOURGLASS.get(), (MovementBehaviour)new HourglassBehavior());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("notice_board_display_target"), (DisplayBehaviour)new NoticeBoardDisplayTarget()), ModRegistry.NOTICE_BOARD_TILE.get());
            DisplayBehaviour textHolderTarget = AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("text_holder_display_target"), (DisplayBehaviour)new TextHolderDisplayTarget());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)textHolderTarget, ModRegistry.SIGN_POST_TILE.get());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)textHolderTarget, ModRegistry.DOORMAT_TILE.get());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)textHolderTarget, ModRegistry.DOORMAT_TILE.get());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("speaker_block_display_target"), (DisplayBehaviour)new SpeakerBlockDisplayTarget()), ModRegistry.SPEAKER_BLOCK_TILE.get());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("blackboard_display_target"), (DisplayBehaviour)new BlackboardDisplayTarget()), ModRegistry.BLACKBOARD_TILE.get());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("globe_display_source"), (DisplayBehaviour)new GlobeDisplaySource()), ModRegistry.GLOBE_TILE.get());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("notice_board_display_source"), (DisplayBehaviour)new NoticeBoardDisplaySource()), ModRegistry.NOTICE_BOARD_TILE.get());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("clock_source"), (DisplayBehaviour)new ClockDisplaySource()), ModRegistry.CLOCK_BLOCK_TILE.get());
            DisplayBehaviour itemDisplaySource = AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("item_display_source"), (DisplayBehaviour)new ItemDisplayDisplaySource());
            AllDisplayBehaviours.assignBlock((DisplayBehaviour)itemDisplaySource, (Block)ModRegistry.PEDESTAL.get());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)itemDisplaySource, ModRegistry.ITEM_SHELF_TILE.get());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)itemDisplaySource, ModRegistry.STATUE_TILE.get());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)itemDisplaySource, ModRegistry.HOURGLASS_TILE.get());
            AllDisplayBehaviours.assignBlockEntity((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("fluid_tank_source"), (DisplayBehaviour)new FluidFillLevelDisplaySource()), ModRegistry.JAR_TILE.get());
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("failed to register supplementaries create behaviors: " + e);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setupClient() {
        CreateCompatImpl.setupClient();
    }

    public static Rotation isClockWise(UnaryOperator<Vec3> rot, Direction dir) {
        Vec3 v = MthUtils.V3itoV3((Vec3i)dir.m_122436_());
        Vec3 v2 = (Vec3)rot.apply(v);
        double dot = v2.m_82526_(new Vec3(0.0, 1.0, 0.0));
        if (dot > 0.0) {
            return Rotation.CLOCKWISE_90;
        }
        if (dot < 0.0) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        return Rotation.NONE;
    }

    public static ItemStack getDisplayedItem(DisplayLinkContext context, BlockEntity source, Predicate<ItemStack> predicate) {
        if (source instanceof ItemDisplayTile) {
            ItemDisplayTile display = (ItemDisplayTile)source;
            ItemStack stack = display.getDisplayedItem();
            if (predicate.test(stack)) {
                return stack;
            }
        } else {
            for (int i = 0; i < 32; ++i) {
                BlockPos pos = context.getSourcePos();
                TransportedItemStackHandlerBehaviour behaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)context.level(), (BlockPos)pos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
                if (behaviour == null) break;
                MutableObject stackHolder = new MutableObject();
                behaviour.handleCenteredProcessingOnAllItems(0.25f, tis -> {
                    stackHolder.setValue((Object)tis.stack);
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                });
                ItemStack stack = (ItemStack)stackHolder.getValue();
                if (stack == null || !predicate.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static void changeState(MovementContext context, BlockState newState) {
        Map blocks = context.contraption.getBlocks();
        if (blocks.containsKey(context.localPos)) {
            context.state = newState;
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)blocks.get(context.localPos);
            StructureTemplate.StructureBlockInfo newInfo = new StructureTemplate.StructureBlockInfo(info.f_74675_(), newState, info.f_74677_());
            blocks.replace(context.localPos, newInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isContraption(MovementContext context, Entity passenger) {
        void var1_1;
        return CreateCompatImpl.isContraption(context, (Entity)var1_1);
    }
}

