/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventsHandler;
import net.mehvahdjukaar.supplementaries.common.items.BombItem;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class SlingshotProjectileEntity
extends ImprovedProjectileEntity
implements IExtraClientSpawnData {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(SlingshotProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected int MAX_AGE = 700;
    private float xRotInc;
    private float yRotInc;
    private float particleCooldown = 0.0f;
    private final Supplier<Integer> light = Suppliers.memoize(() -> {
        Item item = this.m_7846_().m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block b = blockItem.m_40614_();
            return b.m_49966_().m_60791_();
        }
        return 0;
    });

    public SlingshotProjectileEntity(LivingEntity thrower, Level world, ItemStack item, ItemStack throwerStack) {
        this(world, item, throwerStack);
        this.m_6034_(thrower.m_20185_(), thrower.m_20188_() - 0.1, thrower.m_20189_());
        this.m_5602_((Entity)thrower);
    }

    public SlingshotProjectileEntity(Level world, ItemStack item, ItemStack throwerStack) {
        super(ModEntities.SLINGSHOT_PROJECTILE.get(), world);
        this.maxAge = this.MAX_AGE;
        this.m_37446_(item);
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)throwerStack)));
        this.m_20242_(EnchantmentHelper.m_44843_((Enchantment)ModRegistry.STASIS_ENCHANTMENT.get(), (ItemStack)throwerStack) != 0);
        this.yRotInc = (float)(this.f_19796_.m_188499_() ? 1 : -1) * (float)(4.0 * this.f_19796_.m_188583_() + 7.0);
        this.xRotInc = (float)(this.f_19796_.m_188499_() ? 1 : -1) * (float)(4.0 * this.f_19796_.m_188583_() + 7.0);
        this.m_146926_(this.f_19796_.m_188501_() * 360.0f);
        this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
    }

    public SlingshotProjectileEntity(EntityType<SlingshotProjectileEntity> type, Level world) {
        super(type, world);
        this.maxAge = this.MAX_AGE;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return PlatHelper.getEntitySpawnPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)tag.m_128445_("Loyalty"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("Loyalty", ((Byte)this.f_19804_.m_135370_(ID_LOYALTY)).byteValue());
    }

    public void setLoyalty(ItemStack stack) {
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)stack)));
    }

    protected Item m_7881_() {
        return Items.f_41905_;
    }

    protected void m_5790_(EntityHitResult entityRayTraceResult) {
        Entity entity;
        super.m_5790_(entityRayTraceResult);
        if (!this.trySplashPotStuff() && (entity = entityRayTraceResult.m_82443_()) instanceof EnderMan) {
            BlockItem bi;
            Block block;
            EnderMan enderman = (EnderMan)entity;
            Item item = this.m_7846_().m_41720_();
            if (item instanceof BlockItem && ((block = (bi = (BlockItem)item).m_40614_()).m_204297_().m_203656_(BlockTags.f_13046_) || CommonConfigs.Tools.UNRESTRICTED_SLINGSHOT.get().booleanValue()) && enderman.m_32530_() == null) {
                enderman.m_32521_(block.m_49966_());
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void m_8060_(BlockHitResult hit) {
        Player player;
        super.m_8060_(hit);
        if (this.touchedGround) {
            return;
        }
        Entity owner = this.m_19749_();
        boolean success = false;
        Level level = this.m_9236_();
        success = this.trySplashPotStuff();
        if (!success && owner instanceof Player && (player = (Player)owner).m_36326_()) {
            if (CompatHandler.FLAN && (level.f_46443_ || !FlanCompat.canPlace(player, hit.m_82425_()))) {
                return;
            }
            ItemStack stack = this.m_7846_();
            Item item = stack.m_41720_();
            InteractionResult overrideResult = InteractEventsHandler.onItemUsedOnBlockHP(player, level, stack, InteractionHand.MAIN_HAND, hit);
            if (overrideResult.m_19077_()) {
                success = true;
            } else {
                overrideResult = InteractEventsHandler.onItemUsedOnBlock(player, level, stack, InteractionHand.MAIN_HAND, hit);
                if (overrideResult.m_19077_()) {
                    success = true;
                }
            }
            if (!success) {
                Player fakePlayer = FakePlayerManager.getDefault((Entity)this, (Entity)player);
                success = ItemsUtil.place(item, new BlockPlaceContext(level, fakePlayer, InteractionHand.MAIN_HAND, this.m_7846_(), hit)).m_19077_();
            }
        }
        if (success) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private boolean trySplashPotStuff() {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            Object ent = null;
            Item item = this.m_7846_().m_41720_();
            Level level = this.m_9236_();
            if (item instanceof ThrowablePotionItem) {
                ThrownPotion p = new ThrownPotion(level, le);
                p.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                p.m_37446_(this.m_7846_());
                ent = p;
            } else if (item == Items.f_42613_) {
                SmallFireball p = new SmallFireball(level, le, this.m_20185_(), this.m_20186_(), this.m_20189_());
                p.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                p.m_37010_(this.m_7846_());
                ent = p;
            } else if (item instanceof SnowballItem) {
                Snowball s = new Snowball(level, le);
                s.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                s.m_37446_(this.m_7846_());
                ent = s;
            } else if (item instanceof BombItem) {
                BombItem bi = (BombItem)item;
                BombEntity s = new BombEntity(level, le, bi.getType());
                s.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                s.m_37446_(this.m_7846_());
                ent = s;
            } else if (item instanceof EnderpearlItem) {
                ThrownEnderpearl s = new ThrownEnderpearl(level, le);
                s.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                s.m_37446_(this.m_7846_());
                ent = s;
            }
            if (ent != null) {
                level.m_7967_(ent);
                ent.m_8119_();
                return true;
            }
        }
        return false;
    }

    public void m_8119_() {
        if (this.isNoPhysics()) {
            byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
            Entity owner = this.m_19749_();
            if (i > 0 && this.isAcceptableReturnOwner(owner)) {
                Vec3 vector3d = new Vec3(owner.m_20185_() - this.m_20185_(), owner.m_20188_() - this.m_20186_(), owner.m_20189_() - this.m_20189_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vector3d.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vector3d.m_82541_().m_82490_(d0)));
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptableReturnOwner(Entity owner) {
        if (owner != null && owner.m_6084_()) {
            return !(owner instanceof ServerPlayer) || !owner.m_5833_();
        }
        return false;
    }

    public void m_6123_(Player playerEntity) {
        if (this.isNoPhysics() || this.touchedGround) {
            boolean success = playerEntity.m_150110_().f_35937_ || playerEntity.m_150109_().m_36054_(this.m_7846_());
            Level level = this.m_9236_();
            if (!level.f_46443_) {
                if (!success) {
                    this.m_5552_(this.m_7846_(), 0.1f);
                }
            } else {
                level.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 1.4f + 2.0f, false);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean hasReachedEndOfLife() {
        if (this.m_20068_() && this.m_20184_().m_82556_() < 0.005) {
            return true;
        }
        return super.hasReachedEndOfLife() && !this.isNoPhysics();
    }

    public void reachedEndOfLife() {
        if ((Byte)this.f_19804_.m_135370_(ID_LOYALTY) != 0 && this.isAcceptableReturnOwner(this.m_19749_())) {
            this.setNoPhysics(true);
            this.groundTime = 0;
        } else {
            this.m_5552_(this.m_7846_(), 0.1f);
            super.reachedEndOfLife();
        }
    }

    protected void m_37283_() {
        if (!this.isNoPhysics()) {
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            this.m_146926_(this.m_146909_() + this.xRotInc);
            this.m_146922_(this.m_146908_() + this.yRotInc);
            this.particleCooldown += 1.0f;
        } else {
            super.m_37283_();
        }
    }

    public void spawnTrailParticles(Vec3 currentPos, Vec3 newPos) {
        if (!this.isNoPhysics()) {
            double d = this.m_20184_().m_82553_();
            if (this.f_19797_ > 1 && d * (double)this.f_19797_ > 1.5) {
                if (this.m_20068_()) {
                    Vec3 rot = new Vec3(0.325, 0.0, 0.0).m_82524_((float)this.f_19797_ * 0.32f);
                    Vec3 movement = this.m_20184_();
                    Vec3 offset = MthUtils.changeBasisN((Vec3)movement, (Vec3)rot);
                    double px = newPos.f_82479_ + offset.f_82479_;
                    double py = newPos.f_82480_ + offset.f_82480_;
                    double pz = newPos.f_82481_ + offset.f_82481_;
                    movement = movement.m_82490_(0.25);
                    this.m_9236_().m_7106_((ParticleOptions)ModParticles.STASIS_PARTICLE.get(), px, py, pz, movement.f_82479_, movement.f_82480_, movement.f_82481_);
                } else {
                    double interval = 4.0 / (d * 0.95 + 0.05);
                    if ((double)this.particleCooldown > interval) {
                        this.particleCooldown = (float)((double)this.particleCooldown - interval);
                        double x = currentPos.f_82479_;
                        double y = currentPos.f_82480_;
                        double z = currentPos.f_82481_;
                        this.m_9236_().m_7106_((ParticleOptions)ModParticles.SLINGSHOT_PARTICLE.get(), x, y, z, 0.0, 0.01, 0.0);
                    }
                }
            }
        }
    }

    protected float getDeceleration() {
        return this.m_20068_() ? (float)CommonConfigs.Tools.SLINGSHOT_DECELERATION.get().doubleValue() : super.getDeceleration();
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Entity entity = this.m_19749_();
        int id = -1;
        if (entity != null) {
            id = entity.m_19879_();
        }
        buffer.writeInt(id);
        buffer.writeFloat(this.xRotInc);
        buffer.writeFloat(this.yRotInc);
        buffer.writeFloat(this.m_146909_());
        buffer.writeFloat(this.m_146908_());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        int id = buffer.readInt();
        if (id != -1) {
            this.m_5602_(this.m_9236_().m_6815_(id));
        }
        this.xRotInc = buffer.readFloat();
        this.yRotInc = buffer.readFloat();
        this.m_146926_(buffer.readFloat());
        this.m_146922_(buffer.readFloat());
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
    }

    public int getLightEmission() {
        return this.light.get();
    }
}

