/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

class SoftFluidTankInteraction
implements FaucetSource.Tile,
FaucetTarget.Tile {
    SoftFluidTankInteraction() {
    }

    @Override
    public FluidOffer getProvidedFluid(Level level, BlockPos pos, Direction dir, BlockEntity tile) {
        ISoftFluidTankProvider holder;
        if (tile instanceof ISoftFluidTankProvider && (holder = (ISoftFluidTankProvider)tile).canInteractWithSoftFluidTank()) {
            SoftFluidStack fluid = holder.getSoftFluidTank().getFluid();
            if (fluid.isEmpty()) {
                return null;
            }
            return FluidOffer.of(fluid.copy());
        }
        return null;
    }

    @Override
    public void drain(Level level, BlockPos pos, Direction dir, BlockEntity tile, int amount) {
        ISoftFluidTankProvider holder;
        if (tile instanceof ISoftFluidTankProvider && (holder = (ISoftFluidTankProvider)tile).canInteractWithSoftFluidTank()) {
            SoftFluidTank fluidHolder = holder.getSoftFluidTank();
            int am = Math.min(amount, fluidHolder.getFluidCount());
            fluidHolder.getFluid().shrink(am);
            tile.m_6596_();
        }
    }

    @Override
    public Integer fill(Level level, BlockPos pos, BlockEntity tile, SoftFluidStack fluid, int minAmount) {
        ISoftFluidTankProvider holder;
        if (tile instanceof ISoftFluidTankProvider && (holder = (ISoftFluidTankProvider)tile).canInteractWithSoftFluidTank()) {
            SoftFluidTank tank = holder.getSoftFluidTank();
            if (tank.addFluid(fluid.copyWithCount(minAmount))) {
                tile.m_6596_();
                return minAmount;
            }
            return 0;
        }
        return null;
    }
}

