/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.LightUpBlock;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.GunpowderExplosion;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.DecoBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GunpowderBlock
extends LightUpBlock {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.f_61383_;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.f_61382_;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.f_61384_;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.f_61385_;
    public static final IntegerProperty BURNING = ModBlockProperties.BURNING;
    public static final Map<Direction, EnumProperty<RedstoneSide>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    private static final VoxelShape SHAPE_DOT = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<Direction, VoxelShape> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<Direction, VoxelShape> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.m_83110_((VoxelShape)SHAPES_FLOOR.get(Direction.NORTH), (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)Direction.SOUTH, (Object)Shapes.m_83110_((VoxelShape)SHAPES_FLOOR.get(Direction.SOUTH), (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)Direction.EAST, (Object)Shapes.m_83110_((VoxelShape)SHAPES_FLOOR.get(Direction.EAST), (VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)Direction.WEST, (Object)Shapes.m_83110_((VoxelShape)SHAPES_FLOOR.get(Direction.WEST), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private final Map<BlockState, VoxelShape> SHAPES_CACHE;
    private final BlockState crossState;

    private static int getDelay() {
        return CommonConfigs.Tweaks.GUNPOWDER_BURN_SPEED.get();
    }

    private static int getSpreadAge() {
        return CommonConfigs.Tweaks.GUNPOWDER_SPREAD_AGE.get();
    }

    public GunpowderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(NORTH, (Comparable)RedstoneSide.NONE)).m_61124_(EAST, (Comparable)RedstoneSide.NONE)).m_61124_(SOUTH, (Comparable)RedstoneSide.NONE)).m_61124_(WEST, (Comparable)RedstoneSide.NONE)).m_61124_((Property)BURNING, (Comparable)Integer.valueOf(0)));
        this.crossState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(NORTH, (Comparable)RedstoneSide.SIDE)).m_61124_(EAST, (Comparable)RedstoneSide.SIDE)).m_61124_(SOUTH, (Comparable)RedstoneSide.SIDE)).m_61124_(WEST, (Comparable)RedstoneSide.SIDE)).m_61124_((Property)BURNING, (Comparable)Integer.valueOf(0));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState blockstate : this.m_49965_().m_61056_()) {
            if ((Integer)blockstate.m_61143_((Property)BURNING) != 0) continue;
            builder.put((Object)blockstate, (Object)this.calculateVoxelShape(blockstate));
        }
        this.SHAPES_CACHE = builder.build();
        RegHelper.registerBlockFlammability((Block)this, (int)60, (int)300);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, BURNING});
    }

    private VoxelShape calculateVoxelShape(BlockState state) {
        VoxelShape voxelshape = SHAPE_DOT;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SHAPES_FLOOR.get(direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SHAPES_UP.get(direction));
        }
        return voxelshape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.SHAPES_CACHE.get(state.m_61124_((Property)BURNING, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getConnectionState((BlockGetter)context.m_43725_(), this.crossState, context.m_8083_());
    }

    private BlockState getConnectionState(BlockGetter world, BlockState state, BlockPos pos) {
        boolean flag = GunpowderBlock.isDot(state);
        state = this.getMissingConnections(world, (BlockState)this.m_49966_().m_61124_((Property)BURNING, (Comparable)((Integer)state.m_61143_((Property)BURNING))), pos);
        if (!flag || !GunpowderBlock.isDot(state)) {
            boolean flag6;
            boolean flag1 = ((RedstoneSide)state.m_61143_(NORTH)).m_61761_();
            boolean flag2 = ((RedstoneSide)state.m_61143_(SOUTH)).m_61761_();
            boolean flag3 = ((RedstoneSide)state.m_61143_(EAST)).m_61761_();
            boolean flag4 = ((RedstoneSide)state.m_61143_(WEST)).m_61761_();
            boolean flag5 = !flag1 && !flag2;
            boolean bl = flag6 = !flag3 && !flag4;
            if (!flag4 && flag5) {
                state = (BlockState)state.m_61124_(WEST, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag3 && flag5) {
                state = (BlockState)state.m_61124_(EAST, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag1 && flag6) {
                state = (BlockState)state.m_61124_(NORTH, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag2 && flag6) {
                state = (BlockState)state.m_61124_(SOUTH, (Comparable)RedstoneSide.SIDE);
            }
        }
        return state;
    }

    private BlockState getMissingConnections(BlockGetter world, BlockState state, BlockPos pos) {
        boolean flag = !world.m_8055_(pos.m_7494_()).m_60796_(world, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).m_61761_()) continue;
            RedstoneSide redstoneside = this.getConnectingSide(world, pos, direction, flag);
            state = (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside);
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState otherState, LevelAccessor world, BlockPos pos, BlockPos otherPos) {
        RedstoneSide redstoneside;
        BlockState newState = direction == Direction.DOWN ? (this.m_7898_(state, (LevelReader)world, pos) ? state : Blocks.f_50016_.m_49966_()) : (direction == Direction.UP ? this.getConnectionState((BlockGetter)world, state, pos) : ((redstoneside = this.getConnectingSide((BlockGetter)world, pos, direction)).m_61761_() == ((RedstoneSide)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).m_61761_() && !GunpowderBlock.isCross(state) ? (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside) : this.getConnectionState((BlockGetter)world, (BlockState)((BlockState)this.crossState.m_61124_((Property)BURNING, (Comparable)((Integer)state.m_61143_((Property)BURNING)))).m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside), pos)));
        return newState;
    }

    private static boolean isCross(BlockState state) {
        return ((RedstoneSide)state.m_61143_(NORTH)).m_61761_() && ((RedstoneSide)state.m_61143_(SOUTH)).m_61761_() && ((RedstoneSide)state.m_61143_(EAST)).m_61761_() && ((RedstoneSide)state.m_61143_(WEST)).m_61761_();
    }

    private static boolean isDot(BlockState state) {
        return !((RedstoneSide)state.m_61143_(NORTH)).m_61761_() && !((RedstoneSide)state.m_61143_(SOUTH)).m_61761_() && !((RedstoneSide)state.m_61143_(EAST)).m_61761_() && !((RedstoneSide)state.m_61143_(WEST)).m_61761_();
    }

    public void m_7742_(BlockState state, LevelAccessor world, BlockPos pos, int var1, int var2) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.NONE || world.m_8055_((BlockPos)mutable.m_122159_((Vec3i)pos, direction)).m_60713_((Block)this)) continue;
            mutable.m_122173_(Direction.DOWN);
            BlockState blockstate = world.m_8055_((BlockPos)mutable);
            if (!blockstate.m_60713_(Blocks.f_50455_)) {
                BlockPos blockpos = mutable.m_121945_(direction.m_122424_());
                BlockState blockstate1 = blockstate.m_60728_(direction.m_122424_(), world.m_8055_(blockpos), world, (BlockPos)mutable, blockpos);
                GunpowderBlock.m_49908_((BlockState)blockstate, (BlockState)blockstate1, (LevelAccessor)world, (BlockPos)mutable, (int)var1, (int)var2);
            }
            mutable.m_122159_((Vec3i)pos, direction).m_122173_(Direction.UP);
            BlockState blockstate3 = world.m_8055_((BlockPos)mutable);
            if (blockstate3.m_60713_(Blocks.f_50455_)) continue;
            BlockPos pos1 = mutable.m_121945_(direction.m_122424_());
            BlockState blockstate2 = blockstate3.m_60728_(direction.m_122424_(), world.m_8055_(pos1), world, (BlockPos)mutable, pos1);
            GunpowderBlock.m_49908_((BlockState)blockstate3, (BlockState)blockstate2, (LevelAccessor)world, (BlockPos)mutable, (int)var1, (int)var2);
        }
    }

    private RedstoneSide getConnectingSide(BlockGetter world, BlockPos pos, Direction dir) {
        return this.getConnectingSide(world, pos, dir, !world.m_8055_(pos.m_7494_()).m_60796_(world, pos));
    }

    private RedstoneSide getConnectingSide(BlockGetter world, BlockPos pos, Direction dir, boolean canClimbUp) {
        boolean flag;
        BlockPos blockpos = pos.m_121945_(dir);
        BlockState blockstate = world.m_8055_(blockpos);
        if (canClimbUp && (flag = this.canSurviveOn(world, blockpos, blockstate)) && this.canConnectTo(world.m_8055_(blockpos.m_7494_()), world, blockpos.m_7494_(), null)) {
            if (blockstate.m_60783_(world, blockpos, dir.m_122424_())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !this.canConnectTo(blockstate, world, blockpos, dir) && (blockstate.m_60796_(world, blockpos) || !this.canConnectTo(world.m_8055_(blockpos.m_7495_()), world, blockpos.m_7495_(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = world.m_8055_(blockpos);
        return this.canSurviveOn((BlockGetter)world, blockpos, blockstate);
    }

    private boolean canSurviveOn(BlockGetter world, BlockPos pos, BlockState state) {
        return state.m_60783_(world, pos, Direction.UP) || state.m_60713_(Blocks.f_50332_);
    }

    protected boolean canConnectTo(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction dir) {
        Block b = state.m_60734_();
        return b instanceof ILightable || b instanceof TntBlock || b instanceof CampfireBlock || b instanceof AbstractCandleBlock || CompatHandler.DECO_BLOCKS && DecoBlocksCompat.isBrazier(b);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)))).m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(NORTH)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(EAST)))).m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(NORTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(EAST)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)));
            default -> state;
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(EAST)));
            default -> super.m_6943_(state, mirror);
        };
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        if (!oldState.m_60713_(state.m_60734_()) && !world.f_46443_) {
            world.m_186460_(pos, (Block)this, GunpowderBlock.getDelay());
            for (Direction direction : Direction.Plane.VERTICAL) {
                world.m_46672_(pos.m_121945_(direction), (Block)this);
            }
            this.updateNeighborsOfNeighboringWires(world, pos);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, world, pos, newState, isMoving);
            if (!world.f_46443_) {
                for (Direction direction : Direction.values()) {
                    world.m_46672_(pos.m_121945_(direction), (Block)this);
                }
                this.updateNeighborsOfNeighboringWires(world, pos);
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean moving) {
        super.m_6861_(state, world, pos, neighborBlock, neighborPos, moving);
        if (!world.f_46443_) {
            world.m_186460_(pos, (Block)this, GunpowderBlock.getDelay());
        }
    }

    private void updateNeighborsOfNeighboringWires(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(world, pos.m_121945_(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.m_121945_(direction1);
            if (world.m_8055_(blockpos).m_60796_((BlockGetter)world, blockpos)) {
                this.checkCornerChangeAt(world, blockpos.m_7494_());
                continue;
            }
            this.checkCornerChangeAt(world, blockpos.m_7495_());
        }
    }

    private void checkCornerChangeAt(Level world, BlockPos pos) {
        if (world.m_8055_(pos).m_60713_((Block)this)) {
            world.m_46672_(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                world.m_46672_(pos.m_121945_(direction), (Block)this);
            }
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult lightUp = super.m_6227_(state, world, pos, player, hand, hit);
        if (lightUp.m_19077_()) {
            return lightUp;
        }
        if (Utils.mayBuild((Player)player, (BlockPos)pos) && (GunpowderBlock.isCross(state) || GunpowderBlock.isDot(state))) {
            BlockState blockstate = GunpowderBlock.isCross(state) ? this.m_49966_() : this.crossState;
            blockstate = (BlockState)blockstate.m_61124_((Property)BURNING, (Comparable)((Integer)state.m_61143_((Property)BURNING)));
            if ((blockstate = this.getConnectionState((BlockGetter)world, blockstate, pos)) != state) {
                world.m_7731_(pos, blockstate, 3);
                this.updatesOnShapeChange(world, pos, state, blockstate);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void updatesOnShapeChange(Level world, BlockPos pos, BlockState state, BlockState newState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.m_121945_(direction);
            if (((RedstoneSide)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).m_61761_() == ((RedstoneSide)newState.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))).m_61761_() || !world.m_8055_(blockpos).m_60796_((BlockGetter)world, blockpos)) continue;
            world.m_46590_(blockpos, newState.m_60734_(), direction.m_122424_());
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int burning = (Integer)state.m_61143_((Property)BURNING);
        if (!world.f_46443_) {
            if (burning == 8) {
                world.m_7471_(pos, false);
                GunpowderBlock.createMiniExplosion((Level)world, pos, false);
            } else if (burning > 0) {
                if (burning >= GunpowderBlock.getSpreadAge()) {
                    this.lightUpNeighbouringWires(pos, state, (Level)world);
                }
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BURNING, (Comparable)Integer.valueOf(burning + 1)));
                world.m_186460_(pos, (Block)this, GunpowderBlock.getDelay());
            } else {
                for (Direction dir : Direction.values()) {
                    BlockPos p = pos.m_121945_(dir);
                    if (!GunpowderBlock.isFireSource((LevelAccessor)world, p)) continue;
                    this.lightUp(null, state, pos, (LevelAccessor)world, ILightable.FireSourceType.FLAMING_ARROW);
                    world.m_186460_(pos, (Block)this, GunpowderBlock.getDelay());
                    break;
                }
            }
        }
    }

    public static void createMiniExplosion(Level world, BlockPos pos, boolean alwaysFire) {
        GunpowderExplosion explosion = new GunpowderExplosion(world, null, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 0.5f);
        if (ForgeHelper.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(alwaysFire);
    }

    public boolean lightUp(Entity entity, BlockState state, BlockPos pos, LevelAccessor world, ILightable.FireSourceType fireSourceType) {
        boolean ret = super.lightUp(entity, state, pos, world, fireSourceType);
        if (ret) {
            if (!world.m_5776_()) {
                ((Level)world).m_7696_(pos, (Block)this, 0, 0);
            }
            world.m_186460_(pos, (Block)this, GunpowderBlock.getDelay());
        }
        return ret;
    }

    private void lightUpByWire(BlockState state, BlockPos pos, LevelAccessor level) {
        if (!this.isLitUp(state, level, pos)) {
            if (!level.m_5776_()) {
                ((Level)level).m_7696_(pos, (Block)this, 0, 0);
            }
            this.setLitUp(state, level, pos, true);
            level.m_5594_(null, pos, ModSounds.GUNPOWDER_IGNITE.get(), SoundSource.BLOCKS, 2.0f, 1.9f + level.m_213780_().m_188501_() * 0.1f);
        }
    }

    protected void lightUpNeighbouringWires(BlockPos pos, BlockState state, Level world) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockState neighbourState;
            BlockPos p;
            RedstoneSide side = (RedstoneSide)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(dir));
            if (side == RedstoneSide.UP) {
                p = pos.m_121945_(dir).m_7494_();
                neighbourState = world.m_8055_(p);
            } else {
                if (side != RedstoneSide.SIDE) continue;
                p = pos.m_121945_(dir);
                neighbourState = world.m_8055_(p);
                if (!neighbourState.m_60713_((Block)this) && !neighbourState.m_60796_((BlockGetter)world, pos)) {
                    p = p.m_7495_();
                    neighbourState = world.m_8055_(p);
                }
            }
            if (!neighbourState.m_60713_((Block)this)) continue;
            world.m_186460_(p, (Block)this, Math.max(GunpowderBlock.getDelay() - 1, 1));
            this.lightUpByWire(neighbourState, p, (LevelAccessor)world);
        }
    }

    public static boolean isFireSource(BlockState state) {
        Block b = state.m_60734_();
        if (b instanceof TorchBlock && !(b instanceof RedstoneTorchBlock)) {
            return true;
        }
        if (b instanceof CampfireBlock || CompatHandler.DECO_BLOCKS && DecoBlocksCompat.isBrazier(b)) {
            return (Boolean)state.m_61143_((Property)CampfireBlock.f_51227_);
        }
        return state.m_204336_(ModTags.LIGHTS_GUNPOWDER);
    }

    public static boolean isFireSource(LevelAccessor world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return GunpowderBlock.isFireSource(state);
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float height) {
        super.m_142072_(world, state, pos, entity, height);
        if (height > 1.0f) {
            this.extinguish(entity, world.m_8055_(pos), pos, (LevelAccessor)world);
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 300;
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
    }

    @Override
    public boolean isLitUp(BlockState state, LevelAccessor level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)BURNING) != 0;
    }

    @Override
    public void setLitUp(BlockState state, LevelAccessor world, BlockPos pos, boolean lit) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)BURNING, (Comparable)Integer.valueOf(lit ? 1 : 0)), 3);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        if (eventID == 0) {
            this.m_214162_((BlockState)state.m_61124_((Property)BURNING, (Comparable)Integer.valueOf(1)), world, pos, world.f_46441_);
            return true;
        }
        return super.m_8133_(state, world, pos, eventID, eventParam);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int i = (Integer)state.m_61143_((Property)BURNING);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction));
                switch (redstoneside) {
                    case UP: {
                        this.spawnParticlesAlongLine(world, random, pos, i, direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.spawnParticlesAlongLine(world, random, pos, i, Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.spawnParticlesAlongLine(world, random, pos, i, Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    private void spawnParticlesAlongLine(Level world, RandomSource rand, BlockPos pos, int burning, Direction dir1, Direction dir2, float from, float to) {
        float f = to - from;
        float in = (7.5f - (float)(burning - 1)) / 7.5f;
        if (rand.m_188501_() < 1.0f * f * in) {
            float f2 = from + f * rand.m_188501_();
            double x = (double)pos.m_123341_() + 0.5 + (double)(0.4375f * (float)dir1.m_122429_()) + (double)(f2 * (float)dir2.m_122429_());
            double y = (double)pos.m_123342_() + 0.5 + (double)(0.4375f * (float)dir1.m_122430_()) + (double)(f2 * (float)dir2.m_122430_());
            double z = (double)pos.m_123343_() + 0.5 + (double)(0.4375f * (float)dir1.m_122431_()) + (double)(f2 * (float)dir2.m_122431_());
            float velY = (float)burning / 15.0f * 0.03f;
            float velX = rand.m_188501_() * 0.02f - 0.01f;
            float velZ = rand.m_188501_() * 0.02f - 0.01f;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, (double)velX, (double)velY, (double)velZ);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, (double)velX, (double)velY, (double)velZ);
        }
    }
}

