/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.jetbrains.annotations.Nullable;

public class ModMaterials {
    public static final ResourceLocation SIGN_SHEET = new ResourceLocation("textures/atlas/signs.png");
    public static final ResourceLocation BANNER_SHEET = new ResourceLocation("textures/atlas/banner_patterns.png");
    public static final Material CLOCK_HAND = new Material(TextureAtlas.f_118259_, ModTextures.CLOCK_HAND_TEXTURE);
    public static final Material BLACKBOARD_OUTLINE = new Material(TextureAtlas.f_118259_, ModTextures.BLACKBOARD_GRID);
    public static final Material BELLOWS_MATERIAL = new Material(TextureAtlas.f_118259_, ModTextures.BELLOWS_TEXTURE);
    public static final Material BUBBLE_BLOCK_MATERIAL = new Material(TextureAtlas.f_118259_, ModTextures.BUBBLE_BLOCK_TEXTURE);
    public static final Material BLACKBOARD_WHITE = new Material(TextureAtlas.f_118259_, ModTextures.BLACKBOARD_WHITE_TEXTURE);
    public static final Material BLACKBOARD_BLACK = new Material(TextureAtlas.f_118259_, ModTextures.BLACKBOARD_BLACK_TEXTURE);
    public static final Material SAND_MATERIAL = new Material(TextureAtlas.f_118259_, ModTextures.SAND_TEXTURE);
    public static final Material CANNON_MATERIAL = new Material(TextureAtlas.f_118259_, ModTextures.CANNON_TEXTURE);
    public static final Material BOOK_GLINT_MATERIAL = new Material(TextureAtlas.f_118259_, Supplementaries.res("block/books/book_enchanted"));
    public static final Material CANNON_TARGET_MATERIAL = new Material(TextureAtlas.f_118259_, Supplementaries.res("block/cannon_target"));
    public static final Material CANNON_TARGET_RED_MATERIAL = new Material(TextureAtlas.f_118259_, Supplementaries.res("block/cannon_target_charging"));
    public static final Material WIND_VANE_MATERIAL = new Material(TextureAtlas.f_118259_, Supplementaries.res("block/wind_vane"));
    public static final Map<DyeColor, Material> BUNTING_MATERIAL = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), c -> new Material(TextureAtlas.f_118259_, Supplementaries.res("block/buntings/bunting_" + c.m_41065_()))));
    public static final Supplier<Map<BannerPattern, Material>> FLAG_MATERIALS = Suppliers.memoize(() -> {
        IdentityHashMap<BannerPattern, Material> map = new IdentityHashMap<BannerPattern, Material>();
        for (Map.Entry<BannerPattern, ResourceLocation> v : ModTextures.FLAG_TEXTURES.entrySet()) {
            map.put(v.getKey(), new Material(BANNER_SHEET, v.getValue()));
        }
        return map;
    });
    private static final Map<BannerPatternItem, BannerPattern> ITEM_TO_PATTERNS = new IdentityHashMap<BannerPatternItem, BannerPattern>();
    private static final Cache<ResourceLocation, Material> CACHED_MATERIALS = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();

    @Nullable
    public static Material getFlagMaterialForPatternItem(BannerPatternItem item) {
        BannerPattern p = ITEM_TO_PATTERNS.get(item);
        if (p == null) {
            Iterator iterator = ((HolderSet.Named)BuiltInRegistries.f_256878_.m_203431_(item.m_220010_()).get()).iterator();
            if (iterator.hasNext()) {
                Holder j = (Holder)iterator.next();
                ITEM_TO_PATTERNS.put(item, (BannerPattern)j.m_203334_());
                return FLAG_MATERIALS.get().get(j.m_203334_());
            }
            return null;
        }
        return FLAG_MATERIALS.get().get(p);
    }

    public static Material get(ResourceLocation bockTexture) {
        try {
            return (Material)CACHED_MATERIALS.get((Object)bockTexture, () -> new Material(TextureAtlas.f_118259_, bockTexture));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

