/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.NumberRange;
import ca.teamdman.sfml.ast.NumberRangeSet;
import ca.teamdman.sfml.ast.RoundRobin;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public record LabelAccess(List<Label> labels, DirectionQualifier directions, NumberRangeSet slots, RoundRobin roundRobin) implements ASTNode
{
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.labels.stream().map(Objects::toString).collect(Collectors.joining(", ")));
        if (this.roundRobin.isEnabled()) {
            builder.append(" ").append(this.roundRobin);
        }
        if (!this.directions.directions().isEmpty()) {
            builder.append(" ");
            builder.append(this.directions.stream().map(DirectionQualifier::directionToString).collect(Collectors.joining(", "))).append(" SIDE");
        }
        if (!(this.slots.ranges().length <= 0 || this.slots.ranges().length == 1 && this.slots.ranges()[0].equals(NumberRange.MAX_RANGE))) {
            builder.append(" SLOTS");
            for (NumberRange range : this.slots.ranges()) {
                builder.append(" ").append(range);
            }
        }
        return builder.toString();
    }
}

