/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Block;
import ca.teamdman.sfml.ast.BoolExpr;
import ca.teamdman.sfml.ast.Statement;
import java.util.List;
import java.util.function.Predicate;

public record IfStatement(BoolExpr condition, Block trueBlock, Block falseBlock) implements ASTNode,
Statement
{
    @Override
    public void tick(ProgramContext context) {
        Predicate<ProgramContext> condition = this.condition;
        if (context.getExecutionPolicy() == ProgramContext.ExecutionPolicy.EXPLORE_BRANCHES) {
            condition = ctx -> {
                int conditionIndex = ctx.getProgram().getConditionIndex(this);
                return (ctx.getExplorationBranchIndex() & 1 << conditionIndex) != 0;
            };
        }
        if (condition.test(context)) {
            context.pushPath(new ProgramContext.Branch(this, true));
            this.trueBlock.tick(context);
        } else {
            context.pushPath(new ProgramContext.Branch(this, false));
            this.falseBlock.tick(context);
        }
    }

    @Override
    public String toString() {
        String rtn = "IF " + this.condition + " THEN\n" + this.trueBlock.toString().strip().indent(1).stripTrailing();
        if (!this.falseBlock.getStatements().isEmpty()) {
            rtn = rtn + "\nELSE\n" + this.falseBlock.toString().strip().indent(1);
        }
        rtn = rtn + "\nEND";
        return rtn.strip();
    }

    @Override
    public List<Statement> getStatements() {
        return List.of(this.trueBlock, this.falseBlock);
    }
}

