/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Statement;
import java.util.List;

public record Block(List<Statement> statements) implements Statement
{
    @Override
    public void tick(ProgramContext context) {
        for (Statement statement : this.statements) {
            statement.tick(context);
        }
    }

    @Override
    public String toString() {
        StringBuilder rtn = new StringBuilder();
        for (Statement statement : this.statements) {
            if (statement instanceof InputStatement) {
                InputStatement ins = (InputStatement)statement;
                rtn.append(ins.toStringPretty().strip());
            } else if (statement instanceof OutputStatement) {
                OutputStatement outs = (OutputStatement)statement;
                rtn.append(outs.toStringPretty().strip());
            } else {
                rtn.append(statement.toString().strip());
            }
            rtn.append("\n");
        }
        return rtn.toString().strip();
    }

    @Override
    public List<Statement> getStatements() {
        return this.statements;
    }
}

