/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.Statement;
import java.util.List;
import java.util.stream.Stream;

public interface ASTNode {
    default public List<Statement> getStatements() {
        return List.of();
    }

    default public Stream<Statement> getDescendantStatements() {
        Stream.Builder builder = Stream.builder();
        this.getStatements().forEach(s -> {
            builder.accept(s);
            s.getDescendantStatements().forEach(builder);
        });
        return builder.build();
    }

    default public Stream<ResourceIdentifier<?, ?, ?>> getReferencedIOResourceIds() {
        return this.getDescendantStatements().filter(IOStatement.class::isInstance).map(IOStatement.class::cast).flatMap(statement -> statement.resourceLimits().resourceLimits().stream()).map(ResourceLimit::resourceId);
    }
}

