/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.util.SFMUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public record ServerboundLabelGunUsePacket(InteractionHand hand, BlockPos pos, boolean isCtrlKeyDown, boolean isShiftKeyDown) {
    public static void encode(ServerboundLabelGunUsePacket msg, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.hand);
        buf.m_130064_(msg.pos);
        buf.writeBoolean(msg.isCtrlKeyDown);
        buf.writeBoolean(msg.isShiftKeyDown);
    }

    public static ServerboundLabelGunUsePacket decode(FriendlyByteBuf buf) {
        return new ServerboundLabelGunUsePacket((InteractionHand)buf.m_130066_(InteractionHand.class), buf.m_130135_(), buf.readBoolean(), buf.readBoolean());
    }

    public static void handle(ServerboundLabelGunUsePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            ItemStack stack = sender.m_21120_(msg.hand);
            Level level = sender.m_9236_();
            if (!(stack.m_41720_() instanceof LabelGunItem)) {
                return;
            }
            LabelPositionHolder gunLabels = LabelPositionHolder.from(stack);
            BlockPos pos = msg.pos;
            BlockEntity patt2289$temp = level.m_7702_(pos);
            if (patt2289$temp instanceof ManagerBlockEntity) {
                ManagerBlockEntity manager = (ManagerBlockEntity)patt2289$temp;
                manager.getDisk().ifPresent(disk -> {
                    if (msg.isShiftKeyDown) {
                        LabelPositionHolder newLabels = LabelPositionHolder.from(disk);
                        manager.getReferencedLabels().forEach(newLabels::addReferencedLabel);
                        newLabels.save(stack);
                        sender.m_213846_((Component)Constants.LocalizationKeys.LABEL_GUN_CHAT_PULLED.getComponent());
                    } else {
                        gunLabels.save((ItemStack)disk);
                        manager.rebuildProgramAndUpdateDisk();
                        manager.m_6596_();
                        sender.m_213846_((Component)Constants.LocalizationKeys.LABEL_GUN_CHAT_PUSHED.getComponent());
                    }
                });
                return;
            }
            String activeLabel = LabelGunItem.getActiveLabel(stack);
            if (activeLabel.isEmpty()) {
                return;
            }
            if (msg.isCtrlKeyDown) {
                Set cablePositions = CableNetworkManager.getNetworksForLevel(level).flatMap(CableNetwork::getCablePositions).collect(Collectors.toSet());
                Block targetBlock = level.m_8055_(pos).m_60734_();
                Predicate<BlockPos> isAdjacentToCable = p -> Arrays.stream(Direction.values()).anyMatch(d -> cablePositions.contains(p.m_121955_(d.m_122436_())));
                List<BlockPos> positions = SFMUtils.getRecursiveStream((current, nextQueue, results) -> {
                    results.accept(current);
                    SFMUtils.get3DNeighboursIncludingKittyCorner(current).filter(p -> level.m_8055_(p).m_60734_() == targetBlock).filter(isAdjacentToCable).forEach(nextQueue);
                }, pos).toList();
                HashSet<BlockPos> existing = new HashSet<BlockPos>(gunLabels.getPositions(activeLabel));
                boolean anyMissing = positions.stream().anyMatch(p -> !existing.contains(p));
                if (anyMissing) {
                    gunLabels.addAll(activeLabel, positions);
                } else {
                    positions.forEach(p -> gunLabels.remove(activeLabel, (BlockPos)p));
                }
            } else if (msg.isShiftKeyDown) {
                gunLabels.remove(pos);
            } else {
                gunLabels.toggle(activeLabel, pos);
            }
            gunLabels.save(stack);
        });
        ctx.get().setPacketHandled(true);
    }
}

