/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.util.SFMUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityCache {
    private final Long2ObjectMap<Object2ObjectOpenHashMap<Capability<?>, Object2ObjectOpenHashMap<Direction, LazyOptional<?>>>> CACHE = new Long2ObjectOpenHashMap();

    public void clear() {
        this.CACHE.clear();
    }

    public int size() {
        return this.CACHE.values().stream().flatMap(x -> x.values().stream()).mapToInt(Object2ObjectOpenHashMap::size).sum();
    }

    public void overwriteFromOther(BlockPos pos, CapabilityCache other) {
        Object2ObjectOpenHashMap found = (Object2ObjectOpenHashMap)other.CACHE.get(pos.m_121878_());
        if (found != null) {
            this.CACHE.put(pos.m_121878_(), (Object)new Object2ObjectOpenHashMap((Object2ObjectMap)found));
        }
    }

    @Nullable
    public <CAP> LazyOptional<CAP> getCapability(BlockPos pos, Capability<CAP> capKind, @Nullable Direction direction) {
        Object2ObjectOpenHashMap dirMap;
        Object2ObjectOpenHashMap capMap;
        if (this.CACHE.containsKey(pos.m_121878_()) && (capMap = (Object2ObjectOpenHashMap)this.CACHE.get(pos.m_121878_())).containsKey(capKind) && (dirMap = (Object2ObjectOpenHashMap)capMap.get(capKind)).containsKey((Object)direction)) {
            LazyOptional found = (LazyOptional)dirMap.get((Object)direction);
            if (found == null) {
                return null;
            }
            return found;
        }
        return null;
    }

    public void putAll(CapabilityCache other) {
        other.CACHE.forEach((pos, capMap) -> capMap.forEach((capKind, dirMap) -> dirMap.forEach((direction, cap) -> this.putCapability(BlockPos.m_122022_((long)pos), (Capability)capKind, (Direction)direction, (LazyOptional)cap))));
    }

    public Stream<BlockPos> getPositions() {
        return this.CACHE.keySet().longStream().mapToObj(BlockPos::m_122022_);
    }

    public <CAP> LazyOptional<CAP> getOrDiscoverCapability(Level level, BlockPos pos, Capability<CAP> capKind, @Nullable Direction direction) {
        LazyOptional<CAP> found = this.getCapability(pos, capKind, direction);
        if (found != null) {
            return found;
        }
        Optional<ICapabilityProvider> provider = SFMUtils.discoverCapabilityProvider(level, pos);
        if (provider.isPresent()) {
            LazyOptional lazyOptional = provider.get().getCapability(capKind, direction);
            this.putCapability(pos, capKind, direction, lazyOptional);
            lazyOptional.addListener(x -> this.remove(pos, capKind, direction));
            return lazyOptional;
        }
        return LazyOptional.empty();
    }

    public void remove(BlockPos pos, Capability<?> capKind, @Nullable Direction direction) {
        Object2ObjectOpenHashMap capMap;
        if (this.CACHE.containsKey(pos.m_121878_()) && (capMap = (Object2ObjectOpenHashMap)this.CACHE.get(pos.m_121878_())).containsKey(capKind)) {
            Object2ObjectOpenHashMap dirMap = (Object2ObjectOpenHashMap)capMap.get(capKind);
            dirMap.remove((Object)direction);
            if (dirMap.isEmpty()) {
                capMap.remove(capKind);
                if (capMap.isEmpty()) {
                    this.CACHE.remove(pos.m_121878_());
                }
            }
        }
    }

    public <CAP> void putCapability(BlockPos pos, Capability<CAP> capKind, @Nullable Direction direction, LazyOptional<CAP> cap) {
        Object2ObjectOpenHashMap capMap = (Object2ObjectOpenHashMap)this.CACHE.computeIfAbsent(pos.m_121878_(), k -> new Object2ObjectOpenHashMap());
        Object2ObjectOpenHashMap dirMap = (Object2ObjectOpenHashMap)capMap.computeIfAbsent(capKind, k -> new Object2ObjectOpenHashMap());
        dirMap.put((Object)direction, cap);
    }
}

