/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.ICableBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="sfm")
public class CableNetworkManager {
    private static final Map<Level, List<CableNetwork>> NETWORKS = new WeakHashMap<Level, List<CableNetwork>>();

    public static void removeCable(Level level, BlockPos cablePos) {
        CableNetworkManager.getNetworkFromCablePosition(level, cablePos).ifPresent(network -> {
            CableNetworkManager.removeNetwork(network);
            List<CableNetwork> newNetworks = network.withoutCable(cablePos);
            newNetworks.forEach(CableNetworkManager::addNetwork);
        });
    }

    public static Optional<CableNetwork> getOrRegisterNetworkFromManagerPosition(ManagerBlockEntity tile) {
        return CableNetworkManager.getOrRegisterNetworkFromCablePosition(tile.m_58904_(), tile.m_58899_());
    }

    public static Optional<CableNetwork> getNetworkFromPosition(Level level, BlockPos pos) {
        return CableNetworkManager.getNetworksForLevel(level).filter(net -> {
            if (net.CABLE_POSITIONS.contains(pos.m_121878_())) return true;
            if (!net.getCapabilityProviderPositions().anyMatch(arg_0 -> ((BlockPos)pos).equals(arg_0))) return false;
            return true;
        }).findFirst();
    }

    public static Stream<CableNetwork> getNetworksForLevel(Level level) {
        return NETWORKS.getOrDefault(level, Collections.emptyList()).stream().filter(net -> net.getLevel().m_5776_() == level.m_5776_());
    }

    private static Optional<CableNetwork> getNetworkFromCablePosition(Level level, BlockPos pos) {
        return CableNetworkManager.getNetworksForLevel(level).filter(net -> net.containsCablePosition(pos)).findFirst();
    }

    private static void removeNetwork(CableNetwork network) {
        NETWORKS.getOrDefault(network.getLevel(), Collections.emptyList()).remove(network);
    }

    private static void addNetwork(CableNetwork network) {
        NETWORKS.computeIfAbsent(network.getLevel(), k -> new ArrayList()).add(network);
    }

    private static Set<CableNetwork> getCandidateNetworks(Level level, BlockPos pos) {
        return CableNetworkManager.getNetworksForLevel(level).filter(net -> net.isAdjacentToCable(pos)).collect(Collectors.toSet());
    }

    private static Optional<CableNetwork> mergeNetworks(Set<CableNetwork> networks) {
        if (networks.isEmpty()) {
            return Optional.empty();
        }
        Iterator<CableNetwork> iterator = networks.iterator();
        CableNetwork main = iterator.next();
        iterator.forEachRemaining(other -> {
            main.mergeNetwork((CableNetwork)other);
            CableNetworkManager.removeNetwork(other);
        });
        return Optional.of(main);
    }

    public static void unregisterNetworkForTestingPurposes(CableNetwork network) {
        CableNetworkManager.removeNetwork(network);
    }

    public static Optional<CableNetwork> getOrRegisterNetworkFromCablePosition(@Nullable Level level, BlockPos pos) {
        if (level == null) {
            return Optional.empty();
        }
        if (level.m_5776_()) {
            return Optional.empty();
        }
        if (!CableNetwork.isCable(level, pos)) {
            return Optional.empty();
        }
        Optional<CableNetwork> existing = CableNetworkManager.getNetworkFromCablePosition(level, pos);
        if (existing.isPresent()) {
            return existing;
        }
        Set<CableNetwork> candidates = CableNetworkManager.getCandidateNetworks(level, pos);
        if (candidates.isEmpty()) {
            CableNetwork network = new CableNetwork(level);
            CableNetworkManager.addNetwork(network);
            network.rebuildNetwork(pos);
            return Optional.of(network);
        }
        if (candidates.size() == 1) {
            CableNetwork network = candidates.iterator().next();
            network.addCable(pos);
            return Optional.of(network);
        }
        Optional<CableNetwork> result = CableNetworkManager.mergeNetworks(candidates);
        result.ifPresent(net -> net.addCable(pos));
        return result;
    }

    public static List<BlockPos> getBadCableCachePositions(Level level) {
        return CableNetworkManager.getNetworksForLevel(level).flatMap(CableNetwork::getCablePositions).filter(pos -> !(level.m_8055_(pos).m_60734_() instanceof ICableBlock)).collect(Collectors.toList());
    }

    public static void clear() {
        NETWORKS.clear();
    }
}

