/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfml.ast.Program;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class ProgramTemplatePickerScreen
extends Screen {
    private final Consumer<String> CALLBACK;

    public ProgramTemplatePickerScreen(Consumer<String> callback) {
        super((Component)Constants.LocalizationKeys.PROGRAM_TEMPLATE_PICKER_GUI_TITLE.getComponent());
        this.CALLBACK = callback;
    }

    protected void m_7856_() {
        super.m_7856_();
        ResourceManager irm = Minecraft.m_91087_().m_91098_();
        Map found = irm.m_214159_("template_programs", path -> path.m_135815_().endsWith(".sfml") || path.m_135815_().endsWith(".sfm"));
        HashMap templatePrograms = new HashMap();
        for (Map.Entry entry : found.entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    String program = reader.lines().collect(Collectors.joining("\n"));
                    if (program.contains("$REPLACE_RESOURCE_TYPES_HERE$")) {
                        String replacement = SFMResourceTypes.DEFERRED_TYPES.get().getEntries().stream().map(e -> ((ResourceKey)e.getKey()).m_135782_().m_135815_()).map(e -> "INPUT " + e + ":: FROM a").collect(Collectors.joining("\n    "));
                        program = program.replace("$REPLACE_RESOURCE_TYPES_HERE$", replacement);
                    }
                    String finalProgram = program;
                    Program.compile(program, (successProgram, builder) -> templatePrograms.put(successProgram.name().isBlank() ? ((ResourceLocation)entry.getKey()).toString() : successProgram.name(), finalProgram), failure -> templatePrograms.put(((ResourceLocation)entry.getKey()).toString(), finalProgram));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException reader) {}
        }
        int i = 0;
        int buttonWidth = templatePrograms.keySet().stream().mapToInt(arg_0 -> ((Font)this.f_96547_).m_92895_(arg_0)).max().orElse(50) + 10;
        int buttonHeight = 20;
        int paddingX = 5;
        int paddingY = 5;
        int buttonsPerRow = this.f_96543_ / (buttonWidth + paddingX);
        for (Map.Entry entry : templatePrograms.entrySet().stream().sorted((o1, o2) -> Comparator.naturalOrder().compare((String)o1.getKey(), (String)o2.getKey())).toList()) {
            int x = (this.f_96543_ - (buttonWidth + paddingX) * Math.min(buttonsPerRow, templatePrograms.size())) / 2 + paddingX + i % buttonsPerRow * (buttonWidth + paddingX);
            int y = 50 + i / buttonsPerRow * (buttonHeight + paddingY);
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)((String)entry.getKey())), btn -> {
                this.m_7379_();
                this.CALLBACK.accept((String)entry.getValue());
            }).m_252794_(x, y).m_253046_(buttonWidth, buttonHeight).m_253136_());
            ++i;
        }
    }

    public void m_88315_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(graphics);
        this.m_280273_(graphics);
        this.m_280273_(graphics);
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        MutableComponent warning1 = Constants.LocalizationKeys.PROGRAM_TEMPLATE_PICKER_GUI_WARNING_1.getComponent();
        graphics.m_280614_(this.f_96547_, (Component)warning1, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)warning1) / 2, 20, 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)warning1, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)warning1) / 2, 20, 0xFFFFFF, false);
        MutableComponent warning2 = Constants.LocalizationKeys.PROGRAM_TEMPLATE_PICKER_GUI_WARNING_2.getComponent();
        graphics.m_280614_(this.f_96547_, (Component)warning2, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)warning2) / 2, 36, 0xFFFFFF, false);
    }
}

