/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.client.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.client.ProgramTokenContextActions;
import ca.teamdman.sfm.client.gui.EditorUtils;
import ca.teamdman.sfm.client.gui.screen.ExtendedButtonWithTooltip;
import ca.teamdman.sfm.common.Constants;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.joml.Matrix4f;

public class ProgramEditScreen
extends Screen {
    private final String INITIAL_CONTENT;
    private final Consumer<String> CALLBACK;
    private MyMultiLineEditBox textarea;
    private String lastProgram = "";
    private List<MutableComponent> lastProgramWithSyntaxHighlighting = Collections.emptyList();

    public ProgramEditScreen(String initialContent, Consumer<String> callback) {
        super((Component)Constants.LocalizationKeys.PROGRAM_EDIT_SCREEN_TITLE.getComponent());
        this.INITIAL_CONTENT = initialContent;
        this.CALLBACK = callback;
    }

    public static MutableComponent substring(MutableComponent component, int start, int end) {
        MutableComponent rtn = Component.m_237119_();
        AtomicInteger seen = new AtomicInteger(0);
        component.m_7451_((style, content) -> {
            int contentEnd;
            int contentStart = Math.max(start - seen.get(), 0);
            if (contentStart < (contentEnd = Math.min(end - seen.get(), content.length()))) {
                rtn.m_7220_((Component)Component.m_237113_((String)content.substring(contentStart, contentEnd)).m_130948_(style));
            }
            seen.addAndGet(content.length());
            return Optional.empty();
        }, Style.f_131099_);
        return rtn;
    }

    public void scrollToTop() {
        this.textarea.scrollToTop();
    }

    protected void m_7856_() {
        super.m_7856_();
        assert (this.f_96541_ != null);
        this.textarea = (MyMultiLineEditBox)this.m_142416_((GuiEventListener)new MyMultiLineEditBox());
        this.textarea.m_240159_(this.INITIAL_CONTENT);
        this.m_264313_((GuiEventListener)this.textarea);
        this.m_142416_((GuiEventListener)new ExtendedButtonWithTooltip(this.f_96543_ / 2 - 2 - 150, this.f_96544_ / 2 - 100 + 195, 300, 20, CommonComponents.f_130655_, p_97691_ -> this.onClosePerformCallback(), Tooltip.m_257550_((Component)Constants.LocalizationKeys.PROGRAM_EDIT_SCREEN_DONE_BUTTON_TOOLTIP.getComponent())));
    }

    public void onClosePerformCallback() {
        this.CALLBACK.accept(this.textarea.m_239249_());
        assert (this.f_96541_ != null);
        this.f_96541_.popGuiLayer();
    }

    public void m_7379_() {
        if (!this.INITIAL_CONTENT.equals(this.textarea.m_239249_())) {
            assert (this.f_96541_ != null);
            this.f_96541_.pushGuiLayer((Screen)new ConfirmScreen(doSave -> {
                this.f_96541_.popGuiLayer();
                if (doSave) {
                    this.onClosePerformCallback();
                } else {
                    this.f_96541_.popGuiLayer();
                }
            }, (Component)Constants.LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_TITLE.getComponent(), (Component)Constants.LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_MESSAGE.getComponent(), (Component)Constants.LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_YES_BUTTON.getComponent(), (Component)Constants.LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_NO_BUTTON.getComponent()));
        } else {
            super.m_7379_();
        }
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.m_96637_());
            return true;
        }
        return false;
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (Screen.m_96637_() && pCodePoint == ' ') {
            return true;
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if ((pKeyCode == 257 || pKeyCode == 335) && Screen.m_96638_()) {
            this.onClosePerformCallback();
            return true;
        }
        if (pKeyCode == 258) {
            String content = this.textarea.m_239249_();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            EditorUtils.ManipulationResult result = Screen.m_96638_() ? EditorUtils.deindent(content, cursor, selectionCursor) : EditorUtils.indent(content, cursor, selectionCursor);
            this.textarea.m_240159_(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            return true;
        }
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.m_96637_());
            return true;
        }
        if (pKeyCode == 47 && Screen.m_96637_()) {
            String content = this.textarea.m_239249_();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            EditorUtils.ManipulationResult result = EditorUtils.toggleComments(content, cursor, selectionCursor);
            this.textarea.m_240159_(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            return true;
        }
        if (pKeyCode == 32 && Screen.m_96637_()) {
            ProgramTokenContextActions.getContextAction(this.textarea.m_239249_(), this.textarea.getCursorPosition()).ifPresent(Runnable::run);
            this.textarea.rebuild(false);
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_6574_(Minecraft mc, int x, int y) {
        String prev = this.textarea.m_239249_();
        this.m_6575_(mc, x, y);
        super.m_6574_(mc, x, y);
        this.textarea.m_240159_(prev);
    }

    public void m_88315_(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mx, my, partialTicks);
    }

    private class MyMultiLineEditBox
    extends MultiLineEditBox {
        public MyMultiLineEditBox() {
            super(ProgramEditScreen.this.f_96547_, ProgramEditScreen.this.f_96543_ / 2 - 200, ProgramEditScreen.this.f_96544_ / 2 - 110, 400, 200, (Component)Component.m_237113_((String)""), (Component)Component.m_237113_((String)""));
        }

        public void scrollToTop() {
            this.m_240206_(0.0);
        }

        public int getCursorPosition() {
            return this.f_238540_.f_238566_;
        }

        public void setCursorPosition(int cursor) {
            this.f_238540_.f_238566_ = cursor;
        }

        public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
            boolean rtn;
            if (!this.f_93624_) {
                rtn = false;
            } else {
                boolean flag1;
                boolean flag = this.m_239606_(pMouseX, pMouseY);
                boolean bl = flag1 = this.m_239656_() && pMouseX >= (double)(this.m_252754_() + this.f_93618_) && pMouseX <= (double)(this.m_252754_() + this.f_93618_ + 8) && pMouseY >= (double)this.m_252907_() && pMouseY < (double)(this.m_252907_() + this.f_93619_);
                if (flag1 && pButton == 0) {
                    this.f_238779_ = true;
                    rtn = true;
                } else {
                    rtn = false;
                }
            }
            if (rtn) {
                return true;
            }
            if (this.m_239606_(pMouseX, pMouseY) && pButton == 0) {
                this.f_238540_.m_239950_(Screen.m_96638_());
                this.m_239275_(pMouseX, pMouseY);
                return true;
            }
            return false;
        }

        public int getSelectionCursorPosition() {
            return this.f_238540_.f_238550_;
        }

        public void setSelectionCursorPosition(int cursor) {
            this.f_238540_.f_238550_ = cursor;
        }

        private void rebuild(boolean showContextActionHints) {
            ProgramEditScreen.this.lastProgram = this.f_238540_.m_239618_();
            ProgramEditScreen.this.lastProgramWithSyntaxHighlighting = ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(ProgramEditScreen.this.lastProgram, showContextActionHints);
        }

        protected void m_239197_(GuiGraphics graphics, int mx, int my, float partialTicks) {
            Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
            if (!ProgramEditScreen.this.lastProgram.equals(this.f_238540_.m_239618_())) {
                this.rebuild(Screen.m_96637_());
            }
            List<MutableComponent> lines = ProgramEditScreen.this.lastProgramWithSyntaxHighlighting;
            boolean isCursorVisible = this.m_93696_() && this.f_238824_ / 6 % 2 == 0;
            boolean isCursorAtEndOfLine = false;
            int cursorIndex = this.f_238540_.m_239456_();
            int lineX = this.m_252754_() + this.m_239244_();
            int lineY = this.m_252907_() + this.m_239244_();
            int charCount = 0;
            int cursorX = 0;
            int cursorY = 0;
            MultilineTextField.StringView selectedRange = this.f_238540_.m_239982_();
            int selectionStart = selectedRange.f_238590_();
            int selectionEnd = selectedRange.f_238654_();
            for (int line = 0; line < lines.size(); ++line) {
                MutableComponent componentColoured = lines.get(line);
                int lineLength = componentColoured.getString().length();
                Objects.requireNonNull(this.f_238790_);
                int lineHeight = 9 + (line == 0 ? 2 : 0);
                boolean cursorOnThisLine = isCursorVisible && cursorIndex >= charCount && cursorIndex <= charCount + lineLength;
                MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                if (cursorOnThisLine) {
                    isCursorAtEndOfLine = cursorIndex == charCount + lineLength;
                    cursorY = lineY;
                    cursorX = this.f_238790_.m_272077_((Component)ProgramEditScreen.substring(componentColoured, 0, cursorIndex - charCount), (float)lineX, (float)lineY, -1, true, matrix4f, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0) - 1;
                    this.f_238790_.m_272077_((Component)ProgramEditScreen.substring(componentColoured, cursorIndex - charCount, lineLength), (float)cursorX, (float)lineY, -1, true, matrix4f, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                } else {
                    this.f_238790_.m_272077_((Component)componentColoured, (float)lineX, (float)lineY, -1, true, matrix4f, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                buffer.m_109911_();
                if (selectionStart <= charCount + lineLength && selectionEnd > charCount) {
                    int lineSelectionStart = Math.max(selectionStart - charCount, 0);
                    int lineSelectionEnd = Math.min(selectionEnd - charCount, lineLength);
                    int highlightStartX = this.f_238790_.m_92852_((FormattedText)ProgramEditScreen.substring(componentColoured, 0, lineSelectionStart));
                    int highlightEndX = this.f_238790_.m_92852_((FormattedText)ProgramEditScreen.substring(componentColoured, 0, lineSelectionEnd));
                    this.m_280065_(graphics, lineX + highlightStartX, lineY, lineX + highlightEndX, lineY + lineHeight);
                }
                lineY += lineHeight;
                charCount += lineLength + 1;
            }
            if (isCursorAtEndOfLine) {
                graphics.m_280488_(this.f_238790_, "_", cursorX, cursorY, -1);
            } else {
                graphics.m_280509_(cursorX, cursorY - 1, cursorX + 1, cursorY + 1 + 9, -1);
            }
        }
    }
}

