/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.datagen;

import java.util.concurrent.CompletableFuture;
import net.creeperhost.soulshardsrespawn.core.RegistrarSoulShards;
import net.creeperhost.soulshardsrespawn.datagen.GeneratorEntityTags;
import net.creeperhost.soulshardsrespawn.datagen.GeneratorItemModels;
import net.creeperhost.soulshardsrespawn.datagen.providers.SoulShardsLootProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="soulshards", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SoulShardDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            SoulShardDataGen.registerServerProviders(event.getGenerator(), event.getLookupProvider(), event.getExistingFileHelper());
        }
        if (event.includeClient()) {
            SoulShardDataGen.registerClientProviders(event.getGenerator(), event.getExistingFileHelper());
        }
    }

    public static void registerServerProviders(DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        generator.addProvider(true, (DataProvider)new SoulShardsLootProvider(generator.getPackOutput()));
        generator.addProvider(true, (DataProvider)new GeneratorEntityTags(generator.getPackOutput(), lookupProvider, existingFileHelper));
    }

    public static void registerClientProviders(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        generator.addProvider(true, (DataProvider)new GeneratorLanguage(generator));
        generator.addProvider(true, (DataProvider)new GeneratorItemModels(generator, existingFileHelper));
    }

    public static class GeneratorLanguage
    extends LanguageProvider {
        public GeneratorLanguage(DataGenerator gen) {
            super(gen.getPackOutput(), "soulshards", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.soulshards", "Soul Shards Respawn");
            this.add((Item)RegistrarSoulShards.SOUL_SHARD.get(), "Soul Shard");
            this.add("item.soulshards.soul_shard_unbound", "Unbound Soul Shard");
            this.add((Item)RegistrarSoulShards.CORRUPTED_INGOT.get(), "Corrupted Ingot");
            this.add((Item)RegistrarSoulShards.CORRUPTED_ESSENCE.get(), "Corrupted Essence");
            this.add((Item)RegistrarSoulShards.VILE_DUST.get(), "Vile Dust");
            this.add((Item)RegistrarSoulShards.VILE_SWORD.get(), "Vile Sword");
            this.add((Block)RegistrarSoulShards.SOUL_CAGE.get(), "Soul Cage");
            this.add("tooltip.soulshards.bound", "Bound to: %s");
            this.add("tooltip.soulshards.kills", "Souls: %d");
            this.add("tooltip.soulshards.tier", "Tier: %d");
            this.add("tooltip.soulshards.owne", "Owner: %s");
            this.add("tooltip.soulshards.cage_born", "Cage Born");
            this.add("enchantment.soulshards.soul_stealer", "Soul Stealer");
            this.add("chat.soulshards.absorb_disabled", "\u00c2\u00a7cThe shard seems to refuse the trapped soul...");
            this.add("chat.soulshards.command_killed", "\u00c2\u00a72Killed \u00c2\u00a72%d \u00c2\u00a72entities");
            this.add("chat.soulshards.command_not_found", "\u00c2\u00a7cDid not find any spawned entities");
            this.add("commands.soulshards.usage", "/soulshards [setEnt|setKills|setOwner|killall]");
            this.add("commands.soulshards.set_ent.usage", "/soulshards setEnt <entityId>");
            this.add("commands.soulshards.set_ent.success", "Set bound entity of held shard to %s.");
            this.add("commands.soulshards.set_kills.usage", "/soulshards setKills <killCount>");
            this.add("commands.soulshards.set_kills.success", "Set kill count of held shard to %d.");
            this.add("commands.soulshards.set_owner.usage", "/soulshards setOwner [owner]");
            this.add("commands.soulshards.set_owner.success", "Set owner of held shard to %s.");
            this.add("commands.soulshards.kill_all.usage", "/soulshards killall");
            this.add("commands.soulshards.kill_all.success", "Killed %d cage born entities.");
            this.add("commands.soulshards.error.not_a_shard", "Held item is not a Soul Shard.");
            this.add("commands.soulshards.error.not_a_entity", "%s is invalid or not registered.");
            this.add("enchantment.soulshards.soul_stealer.desc", "Increases the souls collected per kill by one per level.");
            this.add("jei.soulshards.soul_shard.desc", "A vessel for the Souls of the slain.\\n\\nObtained by creating a structure in the world and using a %s on the origin block.");
        }
    }
}

