/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.compat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.creeperhost.soulshardsrespawn.compat.jei.MultiBlockDrawable;
import net.creeperhost.soulshardsrespawn.core.RegistrarSoulShards;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class MultiblockCategory
implements IRecipeCategory<Recipe> {
    public static final Component TITLE = Component.m_237113_((String)"Soul Shard Crafting");
    public static final RecipeType<Recipe> SOUL_SHARD_CRAFTING = RecipeType.create((String)"soulshards", (String)"soulshardcrafting", Recipe.class);
    private final IGuiHelper iGuiHelper;
    private final IDrawable multiblock;
    private final IDrawable arrowRight;

    public MultiblockCategory(IGuiHelper iGuiHelper) {
        this.iGuiHelper = iGuiHelper;
        IDrawable obsidian = iGuiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50080_));
        IDrawable quartz = iGuiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50333_));
        IDrawable glowstone = iGuiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50141_));
        this.multiblock = new MultiBlockDrawable(obsidian, glowstone, quartz);
        this.arrowRight = iGuiHelper.drawableBuilder(new ResourceLocation("minecraft", "textures/gui/container/furnace.png"), 176, 14, 24, 17).build();
    }

    @NotNull
    public RecipeType<Recipe> getRecipeType() {
        return SOUL_SHARD_CRAFTING;
    }

    @NotNull
    public Component getTitle() {
        return TITLE;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.iGuiHelper.createBlankDrawable(114, 131);
    }

    @NotNull
    public IDrawable getIcon() {
        return this.iGuiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistrarSoulShards.SOUL_SHARD.get()));
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.multiblock.draw(guiGraphics, 10, 30);
        this.arrowRight.draw(guiGraphics, 60, 30);
        Font font = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280056_(font, "Right-click on the top", 2, 70, 0, false);
        guiGraphics.m_280056_(font, "of the " + ChatFormatting.DARK_PURPLE + "Glowstone Block", 2, 80, 0, false);
        guiGraphics.m_280056_(font, "with a " + ChatFormatting.DARK_PURPLE + recipe.getInput().m_41786_().getString() + ChatFormatting.BLACK + " in hand", 2, 90, 0, false);
        RenderSystem.disableBlend();
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull Recipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (this.isInRect(10, 30, 40, 36, mouseX, mouseY)) {
            components.add((Component)Component.m_237113_((String)("4x " + Blocks.f_50080_.m_49954_().getString())));
            components.add((Component)Component.m_237113_((String)("4x " + Blocks.f_50333_.m_49954_().getString())));
            components.add((Component)Component.m_237113_((String)("1x " + Blocks.f_50141_.m_49954_().getString())));
        }
        return components;
    }

    public boolean isInRect(int x, int y, int xSize, int ySize, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX <= (double)(x + xSize) && mouseY >= (double)y && mouseY <= (double)(y + ySize);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull Recipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 23, 1).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 30).addItemStack(recipe.getOutput());
    }

    public static class Recipe {
        private final ItemStack input;
        private final ItemStack output;

        public Recipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }
    }
}

