/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.soulshardsrespawn.SoulShards;
import net.creeperhost.soulshardsrespawn.api.CageSpawnEvent;
import net.creeperhost.soulshardsrespawn.api.IShardTier;
import net.creeperhost.soulshardsrespawn.api.SoulShardsAPI;
import net.creeperhost.soulshardsrespawn.block.BlockSoulCage;
import net.creeperhost.soulshardsrespawn.core.RegistrarSoulShards;
import net.creeperhost.soulshardsrespawn.core.data.Binding;
import net.creeperhost.soulshardsrespawn.item.ItemSoulShard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TileEntitySoulCage
extends BlockEntity {
    private ItemStackHandler inventory = new SoulCageInventory(){

        protected void onContentsChanged(int slot) {
            TileEntitySoulCage.this.m_6596_();
            super.onContentsChanged(slot);
        }
    };
    private int activeTime;
    private boolean active = false;

    public TileEntitySoulCage(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistrarSoulShards.SOUL_CAGE_TE.get(), blockPos, blockState);
    }

    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        InteractionResultHolder<Binding> result = this.canSpawn();
        if (result.m_19089_() != InteractionResult.SUCCESS) {
            if (this.active) {
                this.setState(false);
                this.f_58857_.m_46586_(this.m_58899_(), this.m_58900_().m_60734_(), this.m_58899_());
            }
            return;
        }
        if (!this.active) {
            this.setState(true);
            this.f_58857_.m_46586_(this.m_58899_(), this.m_58900_().m_60734_(), this.m_58899_());
        }
        ++this.activeTime;
        if (this.activeTime % ((Binding)result.m_19095_()).getTier().getCooldown() == 0) {
            this.spawnEntities();
        }
    }

    private void spawnEntities() {
        Binding binding = this.getBinding();
        if (binding == null || binding.getBoundEntity() == null) {
            return;
        }
        EntityType entityEntry = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(binding.getBoundEntity());
        if (entityEntry == null) {
            return;
        }
        IShardTier tier = binding.getTier();
        block0: for (int i = 0; i < tier.getSpawnAmount(); ++i) {
            for (int attempts = 0; attempts < 5; ++attempts) {
                CageSpawnEvent event;
                LivingEntity entityLiving;
                double z;
                double y;
                double x = (double)this.m_58899_().m_123341_() + (this.f_58857_.f_46441_.m_188500_() - this.f_58857_.f_46441_.m_188500_()) * 4.0 + 0.5;
                BlockPos spawnAt = new BlockPos((int)x, (int)(y = (double)(this.m_58899_().m_123342_() + this.f_58857_.f_46441_.m_188503_(3))), (int)(z = (double)this.m_58899_().m_123343_() + (this.f_58857_.f_46441_.m_188500_() - this.f_58857_.f_46441_.m_188500_()) * 4.0 + 0.5));
                if (spawnAt.equals((Object)this.m_58899_())) {
                    spawnAt = new BlockPos((int)x, (int)y + 1, (int)z);
                }
                if ((entityLiving = (LivingEntity)entityEntry.m_20615_(this.f_58857_)) == null || binding.getTier().checkLight() && !this.canSpawnInLight(entityLiving, spawnAt)) continue;
                entityLiving.m_20035_(spawnAt, this.f_58857_.f_46441_.m_188501_() * 360.0f, 0.0f);
                entityLiving.getPersistentData().m_128379_("cageBorn", true);
                if (!entityLiving.m_6084_() || this.hasReachedSpawnCap(entityLiving) || !this.f_58857_.m_45786_((Entity)entityLiving) || !SoulShards.CONFIG.getBalance().allowBossSpawns() && !entityLiving.m_6072_() || MinecraftForge.EVENT_BUS.post((Event)(event = new CageSpawnEvent(binding, this.inventory.getStackInSlot(0), entityLiving)))) continue;
                this.f_58857_.m_7967_((Entity)entityLiving);
                if (!(entityLiving instanceof Mob)) continue block0;
                ((Mob)entityLiving).m_6518_((ServerLevelAccessor)this.f_58857_, this.f_58857_.m_6436_(spawnAt), MobSpawnType.SPAWNER, null, null);
                continue block0;
            }
        }
    }

    private InteractionResultHolder<Binding> canSpawn() {
        BlockState state = this.m_58900_();
        if (state.m_60734_() != RegistrarSoulShards.SOUL_CAGE.get()) {
            return new InteractionResultHolder(InteractionResult.FAIL, null);
        }
        ItemStack shardStack = this.inventory.getStackInSlot(0);
        if (shardStack.m_41619_() || !(shardStack.m_41720_() instanceof ItemSoulShard)) {
            return new InteractionResultHolder(InteractionResult.FAIL, null);
        }
        Binding binding = this.getBinding();
        if (binding == null || binding.getBoundEntity() == null) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)binding);
        }
        IShardTier tier = binding.getTier();
        if (tier.getSpawnAmount() == 0) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)binding);
        }
        if (SoulShards.CONFIG.getBalance().requireOwnerOnline() && !this.ownerOnline()) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)binding);
        }
        if (!SoulShardsAPI.isAllowed(binding.getBoundEntity())) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)binding);
        }
        if (!SoulShards.CONFIG.getBalance().requireRedstoneSignal() ? (Boolean)state.m_61143_(BlockSoulCage.POWERED) != false && tier.checkRedstone() : (Boolean)state.m_61143_(BlockSoulCage.POWERED) == false) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)binding);
        }
        if (tier.checkPlayer() && this.f_58857_.m_45924_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 16.0, false) == null) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)binding);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)binding);
    }

    private boolean canSpawnInLight(LivingEntity entityLiving, BlockPos pos) {
        boolean light = this.f_58857_.m_5518_().m_75831_(this.m_58899_(), 15) <= 8;
        return !(entityLiving instanceof Mob) || light;
    }

    private boolean hasReachedSpawnCap(LivingEntity living) {
        AABB box = new AABB((double)(this.m_58899_().m_123341_() - 16), (double)(this.m_58899_().m_123342_() - 16), (double)(this.m_58899_().m_123343_() - 16), (double)(this.m_58899_().m_123341_() + 16), (double)(this.m_58899_().m_123342_() + 16), (double)(this.m_58899_().m_123343_() + 16));
        int mobCount = this.f_58857_.m_6443_(living.getClass(), box, e -> e != null && e.getPersistentData().m_128471_("cageBorn")).size();
        return mobCount >= SoulShards.CONFIG.getBalance().getSpawnCap();
    }

    public void setState(boolean active) {
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof BlockSoulCage)) {
            return;
        }
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_(BlockSoulCage.ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
        this.active = active;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.activeTime = tag.m_128451_("activeTime");
        this.active = tag.m_128471_("active");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("activeTime", this.activeTime);
        tag.m_128379_("active", this.active);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap != ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        return LazyOptional.of(() -> this.inventory).cast();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return super.getCapability(cap);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nullable
    public Binding getBinding() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemSoulShard)) {
            return null;
        }
        return ((ItemSoulShard)stack.m_41720_()).getBinding(stack);
    }

    public boolean ownerOnline() {
        Binding binding = this.getBinding();
        return binding != null && binding.getOwner() != null && this.f_58857_.m_7654_().m_6846_().m_11259_(binding.getOwner()) == null;
    }

    public static class SoulCageInventory
    extends ItemStackHandler {
        public SoulCageInventory() {
            super(1);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!(stack.m_41720_() instanceof ItemSoulShard)) {
                return stack;
            }
            Binding binding = ((ItemSoulShard)stack.m_41720_()).getBinding(stack);
            if (binding == null || binding.getBoundEntity() == null || !SoulShardsAPI.isAllowed(binding.getBoundEntity())) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }
}

