/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.util.StringRepresentable;

public enum InventoryOrder implements StringRepresentable
{
    MAIN_FIRST("main_first"),
    INCEPTED_FIRST("incepted_first");

    private final String name;
    private static final Map<String, InventoryOrder> NAME_VALUES;
    private static final InventoryOrder[] VALUES;

    private InventoryOrder(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public InventoryOrder next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static InventoryOrder fromName(String name) {
        return NAME_VALUES.getOrDefault(name, MAIN_FIRST);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (InventoryOrder value : InventoryOrder.values()) {
            builder.put((Object)value.getSerializedName(), (Object)value);
        }
        NAME_VALUES = builder.build();
        VALUES = InventoryOrder.values();
    }
}

