/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;

public class SyncClientInfoPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedbackpacks", "sync_client_info");
    private final int slotIndex;
    @Nullable
    private final CompoundTag renderInfoNbt;
    private final int columnsTaken;

    public SyncClientInfoPacket(int slotNumber, @Nullable CompoundTag renderInfoNbt, int columnsTaken) {
        this.slotIndex = slotNumber;
        this.renderInfoNbt = renderInfoNbt;
        this.columnsTaken = columnsTaken;
    }

    public SyncClientInfoPacket(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readNbt(), buffer.readInt());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        if (this.renderInfoNbt == null || !(player.containerMenu instanceof BackpackContainer)) {
            return;
        }
        ItemStack backpack = (ItemStack)player.getInventory().items.get(this.slotIndex);
        IBackpackWrapper backpackWrapper = BackpackWrapper.fromData(backpack);
        backpackWrapper.getRenderInfo().deserializeFrom(this.renderInfoNbt);
        backpackWrapper.setColumnsTaken(this.columnsTaken, false);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slotIndex);
        buffer.writeNbt((Tag)this.renderInfoNbt);
        buffer.writeInt(this.columnsTaken);
    }

    public ResourceLocation id() {
        return ID;
    }
}

