/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IContextAwareContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class BackpackOpenPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedbackpacks", "backpack_open");
    private static final int CHEST_SLOT = 38;
    private static final int OFFHAND_SLOT = 40;
    private final int slotIndex;
    private final String identifier;
    private final String handlerName;

    public BackpackOpenPacket() {
        this(-1);
    }

    public BackpackOpenPacket(int backpackSlot) {
        this(backpackSlot, "");
    }

    public BackpackOpenPacket(int backpackSlot, String identifier, String handlerName) {
        this.slotIndex = backpackSlot;
        this.identifier = identifier;
        this.handlerName = handlerName;
    }

    public BackpackOpenPacket(int backpackSlot, String identifier) {
        this(backpackSlot, identifier, "");
    }

    public BackpackOpenPacket(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readUtf(), buffer.readUtf());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(@Nullable Player player) {
        if (player == null) {
            return;
        }
        if (!this.handlerName.isEmpty()) {
            BackpackContainer backpackContainer;
            AbstractContainerMenu abstractContainerMenu;
            int adjustedSlotIndex = this.slotIndex;
            if (adjustedSlotIndex == 38) {
                adjustedSlotIndex -= 36;
            } else if (adjustedSlotIndex == 40) {
                adjustedSlotIndex = 0;
            }
            BackpackContext.Item backpackContext = new BackpackContext.Item(this.handlerName, this.identifier, adjustedSlotIndex, player.containerMenu instanceof InventoryMenu || (abstractContainerMenu = player.containerMenu) instanceof BackpackContainer && (backpackContainer = (BackpackContainer)abstractContainerMenu).getBackpackContext().wasOpenFromInventory());
            this.openBackpack(player, backpackContext);
        } else {
            AbstractContainerMenu adjustedSlotIndex = player.containerMenu;
            if (adjustedSlotIndex instanceof BackpackContainer) {
                BackpackContainer backpackContainer = (BackpackContainer)adjustedSlotIndex;
                backpackContext = backpackContainer.getBackpackContext();
                if (this.slotIndex == -1) {
                    this.openBackpack(player, ((BackpackContext)backpackContext).getParentBackpackContext());
                } else if (backpackContainer.isStorageInventorySlot(this.slotIndex)) {
                    this.openBackpack(player, ((BackpackContext)backpackContext).getSubBackpackContext(this.slotIndex));
                }
            } else {
                backpackContext = player.containerMenu;
                if (backpackContext instanceof IContextAwareContainer) {
                    IContextAwareContainer contextAwareContainer = (IContextAwareContainer)backpackContext;
                    backpackContext = contextAwareContainer.getBackpackContext();
                    this.openBackpack(player, (BackpackContext)backpackContext);
                } else {
                    this.findAndOpenFirstBackpack(player);
                }
            }
        }
    }

    private void findAndOpenFirstBackpack(Player player) {
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryName, identifier, slot) -> {
            BackpackContext.Item backpackContext = new BackpackContext.Item(inventoryName, identifier, slot);
            player.openMenu((MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpack.getHoverName()), backpackContext::toBuffer);
            return true;
        });
    }

    private void openBackpack(Player player, BackpackContext backpackContext) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpackContext.getDisplayName(player)), backpackContext::toBuffer);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slotIndex);
        buffer.writeUtf(this.identifier);
        buffer.writeUtf(this.handlerName);
    }

    public ResourceLocation id() {
        return ID;
    }
}

