/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedcore.client.render.ClientStorageContentsTooltipBase;

public class BackpackContentsPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedbackpacks", "backpack_contents");
    private final UUID backpackUuid;
    @Nullable
    private final CompoundTag backpackContents;

    public BackpackContentsPacket(UUID backpackUuid, @Nullable CompoundTag backpackContents) {
        this.backpackUuid = backpackUuid;
        this.backpackContents = backpackContents;
    }

    public BackpackContentsPacket(FriendlyByteBuf buffer) {
        this(buffer.readUUID(), buffer.readNbt());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        if (this.backpackContents == null) {
            return;
        }
        BackpackStorage.get().setBackpackContents(this.backpackUuid, this.backpackContents);
        ClientStorageContentsTooltipBase.refreshContents();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.backpackUuid);
        buffer.writeNbt((Tag)this.backpackContents);
    }

    public ResourceLocation id() {
        return ID;
    }
}

