/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.p3pp3rf1y.sophisticatedbackpacks.data.SBInjectLootSubProvider;
import net.p3pp3rf1y.sophisticatedbackpacks.data.SBLootEnabledCondition;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;

public class SBLootModifierProvider
extends GlobalLootModifierProvider {
    SBLootModifierProvider(PackOutput packOutput) {
        super(packOutput, "sophisticatedbackpacks");
    }

    protected void start() {
        this.addInjectLootTableModifier(SBInjectLootSubProvider.SIMPLE_DUNGEON, BuiltInLootTables.SIMPLE_DUNGEON);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.ABANDONED_MINESHAFT, BuiltInLootTables.ABANDONED_MINESHAFT);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.DESERT_PYRAMID, BuiltInLootTables.DESERT_PYRAMID);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.WOODLAND_MANSION, BuiltInLootTables.WOODLAND_MANSION);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.SHIPWRECK_TREASURE, BuiltInLootTables.SHIPWRECK_TREASURE);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.BASTION_TREASURE, BuiltInLootTables.BASTION_TREASURE);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.END_CITY_TREASURE, BuiltInLootTables.END_CITY_TREASURE);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.NETHER_BRIDGE, BuiltInLootTables.NETHER_BRIDGE);
    }

    private void addInjectLootTableModifier(ResourceLocation lootTable, ResourceLocation lootTableToInjectInto) {
        this.add(lootTableToInjectInto.getPath(), (IGlobalLootModifier)new InjectLootModifier(lootTable, lootTableToInjectInto), new ICondition[0]);
    }

    public static class InjectLootModifier
    extends LootModifier {
        public static final Codec<InjectLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ResourceLocation.CODEC.fieldOf("loot_table").forGetter(m -> m.lootTable), (App)ResourceLocation.CODEC.fieldOf("loot_table_to_inject_into").forGetter(m -> m.lootTableToInjectInto))).apply((Applicative)inst, InjectLootModifier::new));
        private final ResourceLocation lootTable;
        private final ResourceLocation lootTableToInjectInto;

        protected InjectLootModifier(LootItemCondition[] conditions, ResourceLocation lootTable, ResourceLocation lootTableToInjectInto) {
            super(conditions);
            this.lootTable = lootTable;
            this.lootTableToInjectInto = lootTableToInjectInto;
        }

        protected InjectLootModifier(ResourceLocation lootTable, ResourceLocation lootTableToInjectInto) {
            this(new LootItemCondition[]{SBLootEnabledCondition.builder().build(), LootTableIdCondition.builder((ResourceLocation)lootTableToInjectInto).build()}, lootTable, lootTableToInjectInto);
        }

        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            LootTable table = context.getResolver().getLootTable(this.lootTable);
            table.getRandomItemsRaw(context, arg_0 -> generatedLoot.add(arg_0));
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return ModItems.INJECT_LOOT.get();
        }
    }
}

