/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackSettingsScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.jei.DyeRecipesMaker;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.BackpackUpgradeRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsScreen;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.CraftingContainerRecipeTransferHandlerBase;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.SettingsGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.StorageGhostIngredientHandler;

@JeiPlugin
public class SBPPlugin
implements IModPlugin {
    private static Consumer<IRecipeCatalystRegistration> additionalCatalystRegistrar = registration -> {};

    public static void setAdditionalCatalystRegistrar(Consumer<IRecipeCatalystRegistration> additionalCatalystRegistrar) {
        SBPPlugin.additionalCatalystRegistrar = additionalCatalystRegistrar;
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("sophisticatedbackpacks", "default");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        IIngredientSubtypeInterpreter backpackNbtInterpreter = (itemStack, context) -> {
            IBackpackWrapper wrapper = BackpackWrapper.fromData(itemStack);
            return "{clothColor:" + wrapper.getMainColor() + ",borderColor:" + wrapper.getAccentColor() + "}";
        };
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.BACKPACK.get()), backpackNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.COPPER_BACKPACK.get()), backpackNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.IRON_BACKPACK.get()), backpackNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.GOLD_BACKPACK.get()), backpackNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.DIAMOND_BACKPACK.get()), backpackNbtInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.NETHERITE_BACKPACK.get()), backpackNbtInterpreter);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(BackpackScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BackpackScreen>(){

            public List<Rect2i> getGuiExtraAreas(BackpackScreen gui) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                gui.getUpgradeSlotsRectangle().ifPresent(ret::add);
                ret.addAll(gui.getUpgradeSettingsControl().getTabRectangles());
                gui.getSortButtonsRectangle().ifPresent(ret::add);
                return ret;
            }
        });
        registration.addGuiContainerHandler(BackpackSettingsScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BackpackSettingsScreen>(){

            public List<Rect2i> getGuiExtraAreas(BackpackSettingsScreen gui) {
                return new ArrayList<Rect2i>(gui.getSettingsTabControl().getTabRectangles());
            }
        });
        registration.addGhostIngredientHandler(BackpackScreen.class, (IGhostIngredientHandler)new StorageGhostIngredientHandler());
        registration.addGhostIngredientHandler(SettingsScreen.class, (IGhostIngredientHandler)new SettingsGhostIngredientHandler());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.CRAFTING, DyeRecipesMaker.getRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, ClientRecipeHelper.transformAllRecipesOfType((net.minecraft.world.item.crafting.RecipeType)net.minecraft.world.item.crafting.RecipeType.CRAFTING, BackpackUpgradeRecipe.class, ClientRecipeHelper::copyShapedRecipe));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.CRAFTING_UPGRADE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.STONECUTTER_UPGRADE.get()), new RecipeType[]{RecipeTypes.STONECUTTING});
        additionalCatalystRegistrar.accept(registration);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IRecipeTransferHandlerHelper handlerHelper = registration.getTransferHelper();
        IStackHelper stackHelper = registration.getJeiHelpers().getStackHelper();
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingContainerRecipeTransferHandlerBase<BackpackContainer>(handlerHelper, stackHelper){

            public Class<BackpackContainer> getContainerClass() {
                return BackpackContainer.class;
            }
        }, RecipeTypes.CRAFTING);
    }
}

