/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IContextAwareContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsPacket;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.BackpackMainSettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHelper;

public class BackpackSettingsContainerMenu
extends SettingsContainerMenu<IBackpackWrapper>
implements IContextAwareContainer {
    private final BackpackContext backpackContext;
    private CompoundTag lastSettingsNbt = null;

    protected BackpackSettingsContainerMenu(int windowId, Player player, BackpackContext backpackContext) {
        super(ModItems.SETTINGS_CONTAINER_TYPE.get(), windowId, player, (IStorageWrapper)backpackContext.getBackpackWrapper(player));
        this.backpackContext = backpackContext;
    }

    public static BackpackSettingsContainerMenu fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new BackpackSettingsContainerMenu(windowId, playerInventory.player, BackpackContext.fromBuffer(buffer, playerInventory.player.level()));
    }

    public void detectSettingsChangeAndReload() {
        if (this.player.level().isClientSide) {
            ((IBackpackWrapper)this.storageWrapper).getContentsUuid().ifPresent(uuid -> {
                BackpackStorage storage = BackpackStorage.get();
                if (storage.removeUpdatedBackpackSettingsFlag((UUID)uuid)) {
                    ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().reloadFrom(storage.getOrCreateBackpackContents((UUID)uuid));
                }
            });
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.sendBackpackSettingsToClient();
    }

    private void sendBackpackSettingsToClient() {
        if (this.player.level().isClientSide) {
            return;
        }
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)((IBackpackWrapper)this.storageWrapper).getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().getNbt().copy();
            ((IBackpackWrapper)this.storageWrapper).getContentsUuid().ifPresent(uuid -> {
                CompoundTag settingsContents = new CompoundTag();
                CompoundTag settingsNbt = ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().getNbt();
                if (!settingsNbt.isEmpty()) {
                    settingsContents.put("settings", (Tag)settingsNbt);
                    PacketHelper.sendToPlayer((CustomPacketPayload)new BackpackContentsPacket((UUID)uuid, settingsContents), (ServerPlayer)((ServerPlayer)this.player));
                }
            });
        }
    }

    @Override
    public BackpackContext getBackpackContext() {
        return this.backpackContext;
    }

    static {
        SettingsContainerMenu.addFactory((String)"backpackGlobal", BackpackMainSettingsContainer::new);
    }
}

