/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IEnergyStorageUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IFluidHandlerWrapperUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackSettingsHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.InventoryModificationHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.LootHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;

public class BackpackWrapper
implements IBackpackWrapper {
    public static final int DEFAULT_CLOTH_COLOR = 13394234;
    public static final int DEFAULT_BORDER_COLOR = 6434330;
    private static final String CLOTH_COLOR_TAG = "clothColor";
    private static final String BORDER_COLOR_TAG = "borderColor";
    private static final String OPEN_TAB_ID_TAG = "openTabId";
    private static final String SORT_BY_TAG = "sortBy";
    private static final String CONTENTS_UUID_TAG = "contentsUuid";
    private static final String INVENTORY_SLOTS_TAG = "inventorySlots";
    private static final String UPGRADE_SLOTS_TAG = "upgradeSlots";
    private static final String LOOT_TABLE_NAME_TAG = "lootTableName";
    private static final String LOOT_PERCENTAGE_TAG = "lootPercentage";
    private static final String COLUMNS_TAKEN_TAG = "columnsTaken";
    @Nullable
    private ItemStack backpack;
    private Runnable backpackSaveHandler = () -> {};
    private Runnable inventorySlotChangeHandler = () -> {};
    @Nullable
    private InventoryHandler handler = null;
    @Nullable
    private UpgradeHandler upgradeHandler = null;
    @Nullable
    private InventoryIOHandler inventoryIOHandler = null;
    @Nullable
    private InventoryModificationHandler inventoryModificationHandler = null;
    @Nullable
    private BackpackSettingsHandler settingsHandler = null;
    private boolean fluidHandlerInitialized = false;
    @Nullable
    private IStorageFluidHandler fluidHandler = null;
    private boolean energyStorageInitialized = false;
    @Nullable
    private IEnergyStorage energyStorage = null;
    @Nullable
    private BackpackRenderInfo renderInfo;
    private IntConsumer onSlotsChange = diff -> {};
    private Runnable onInventoryHandlerRefresh = () -> {};
    private Runnable upgradeCachesInvalidatedHandler = () -> {};

    public static IBackpackWrapper fromData(ItemStack stack) {
        return ((BackpackWrapper)stack.getData(ModItems.BACKPACK_WRAPPER)).setBackpackStack(stack);
    }

    public static Optional<IBackpackWrapper> fromExistingData(ItemStack stack) {
        return stack.getExistingData(ModItems.BACKPACK_WRAPPER).map(wrapper -> wrapper.setBackpackStack(stack));
    }

    public void setSaveHandler(Runnable saveHandler) {
        this.backpackSaveHandler = saveHandler;
        this.refreshInventoryForUpgradeProcessing();
    }

    public void setInventorySlotChangeHandler(Runnable slotChangeHandler) {
        this.inventorySlotChangeHandler = slotChangeHandler;
    }

    public ITrackedContentsItemHandler getInventoryForUpgradeProcessing() {
        if (this.inventoryModificationHandler == null) {
            this.inventoryModificationHandler = new InventoryModificationHandler(this);
        }
        return this.inventoryModificationHandler.getModifiedInventoryHandler();
    }

    public InventoryHandler getInventoryHandler() {
        if (this.handler == null) {
            this.handler = new BackpackInventoryHandler(this.getNumberOfInventorySlots() - this.getNumberOfSlotRows() * this.getColumnsTaken(), this, this.getBackpackContentsNbt(), () -> {
                this.markBackpackContentsDirty();
                this.inventorySlotChangeHandler.run();
            }, StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
            this.handler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
        }
        return this.handler;
    }

    private int getNumberOfInventorySlots() {
        Optional inventorySlots = NBTHelper.getInt((ItemStack)this.getBackpackStack(), (String)INVENTORY_SLOTS_TAG);
        if (inventorySlots.isPresent()) {
            return (Integer)inventorySlots.get();
        }
        int itemInventorySlots = ((BackpackItem)this.getBackpackStack().getItem()).getNumberOfSlots();
        this.setNumberOfInventorySlots(itemInventorySlots);
        return itemInventorySlots;
    }

    public int getNumberOfSlotRows() {
        int itemInventorySlots = this.getNumberOfInventorySlots();
        return (int)Math.ceil(itemInventorySlots <= 81 ? (double)itemInventorySlots / 9.0 : (double)itemInventorySlots / 12.0);
    }

    private void setNumberOfInventorySlots(int itemInventorySlots) {
        NBTHelper.setInteger((ItemStack)this.getBackpackStack(), (String)INVENTORY_SLOTS_TAG, (int)itemInventorySlots);
    }

    private CompoundTag getBackpackContentsNbt() {
        return BackpackStorage.get().getOrCreateBackpackContents(this.getOrCreateContentsUuid());
    }

    private void markBackpackContentsDirty() {
        BackpackStorage.get().setDirty();
    }

    public ITrackedContentsItemHandler getInventoryForInputOutput() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler((IStorageWrapper)this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    public Optional<IStorageFluidHandler> getFluidHandler() {
        if (!this.fluidHandlerInitialized) {
            BackpackFluidHandler wrappedHandler = this.getUpgradeHandler().getTypeWrappers(TankUpgradeItem.TYPE).isEmpty() ? null : new BackpackFluidHandler(this);
            List fluidHandlerWrapperUpgrades = this.getUpgradeHandler().getWrappersThatImplement(IFluidHandlerWrapperUpgrade.class);
            for (IFluidHandlerWrapperUpgrade fluidHandlerWrapperUpgrade : fluidHandlerWrapperUpgrades) {
                wrappedHandler = fluidHandlerWrapperUpgrade.wrapHandler(wrappedHandler, this.getBackpackStack());
            }
            this.fluidHandler = wrappedHandler;
        }
        return Optional.ofNullable(this.fluidHandler);
    }

    @Override
    public Optional<IFluidHandlerItem> getItemFluidHandler() {
        return this.getFluidHandler().map(fh -> new FluidHandlerItemWrapper(this.getBackpackStack(), (IFluidHandler)fh));
    }

    public Optional<IEnergyStorage> getEnergyStorage() {
        if (!this.energyStorageInitialized) {
            IEnergyStorage wrappedStorage = this.getUpgradeHandler().getWrappersThatImplement(IEnergyStorage.class).stream().findFirst().orElse(null);
            for (IEnergyStorageUpgradeWrapper energyStorageWrapperUpgrade : this.getUpgradeHandler().getWrappersThatImplement(IEnergyStorageUpgradeWrapper.class)) {
                wrappedStorage = energyStorageWrapperUpgrade.wrapStorage(wrappedStorage);
            }
            this.energyStorage = wrappedStorage;
        }
        return this.energyStorage == null || this.energyStorage.getMaxEnergyStored() == 0 ? Optional.empty() : Optional.of(this.energyStorage);
    }

    @Override
    public void copyDataTo(IStorageWrapper otherStorageWrapper) {
        this.getContentsUuid().ifPresent(originalUuid -> {
            this.getInventoryHandler().copyStacksTo(otherStorageWrapper.getInventoryHandler());
            this.getUpgradeHandler().copyTo(otherStorageWrapper.getUpgradeHandler());
            this.getSettingsHandler().copyTo(otherStorageWrapper.getSettingsHandler());
        });
    }

    @Override
    public IBackpackWrapper setBackpackStack(ItemStack backpack) {
        this.backpack = backpack;
        if (this.renderInfo == null) {
            this.renderInfo = new BackpackRenderInfo(backpack, () -> this.backpackSaveHandler);
        }
        return this;
    }

    @Override
    public BackpackSettingsHandler getSettingsHandler() {
        if (this.settingsHandler == null) {
            this.settingsHandler = this.getContentsUuid().isPresent() ? new BackpackSettingsHandler(this, this.getBackpackContentsNbt(), this::markBackpackContentsDirty) : IBackpackWrapper.Noop.INSTANCE.getSettingsHandler();
        }
        return this.settingsHandler;
    }

    public UpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = this.getContentsUuid().isPresent() ? new UpgradeHandler(this.getNumberOfUpgradeSlots(), this, this.getBackpackContentsNbt(), this::markBackpackContentsDirty, () -> {
                if (this.handler != null) {
                    this.handler.clearListeners();
                    this.handler.setBaseSlotLimit(StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
                }
                this.getInventoryHandler().clearListeners();
                this.handler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
                this.inventoryIOHandler = null;
                this.inventoryModificationHandler = null;
                this.fluidHandlerInitialized = false;
                this.fluidHandler = null;
                this.energyStorageInitialized = false;
                this.energyStorage = null;
                this.upgradeCachesInvalidatedHandler.run();
            }){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return super.isItemValid(slot, stack) && (stack.isEmpty() || "sophisticatedbackpacks".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace()) || stack.is(ModItems.BACKPACK_UPGRADE_TAG));
                }
            } : IBackpackWrapper.Noop.INSTANCE.getUpgradeHandler();
        }
        return this.upgradeHandler;
    }

    public void setUpgradeCachesInvalidatedHandler(Runnable handler) {
        this.upgradeCachesInvalidatedHandler = handler;
    }

    private int getNumberOfUpgradeSlots() {
        Optional upgradeSlots = NBTHelper.getInt((ItemStack)this.getBackpackStack(), (String)UPGRADE_SLOTS_TAG);
        if (upgradeSlots.isPresent()) {
            return (Integer)upgradeSlots.get();
        }
        int itemUpgradeSlots = ((BackpackItem)this.getBackpackStack().getItem()).getNumberOfUpgradeSlots();
        this.setNumberOfUpgradeSlots(itemUpgradeSlots);
        return itemUpgradeSlots;
    }

    public Optional<UUID> getContentsUuid() {
        return NBTHelper.getUniqueId((ItemStack)this.getBackpackStack(), (String)CONTENTS_UUID_TAG);
    }

    private UUID getOrCreateContentsUuid() {
        Optional<UUID> contentsUuid = this.getContentsUuid();
        if (contentsUuid.isPresent()) {
            return contentsUuid.get();
        }
        this.clearDummyHandlers();
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        this.migrateBackpackContents(newUuid);
        return newUuid;
    }

    private void clearDummyHandlers() {
        if (this.upgradeHandler == IBackpackWrapper.Noop.INSTANCE.getUpgradeHandler()) {
            this.upgradeHandler = null;
        }
        if (this.settingsHandler == IBackpackWrapper.Noop.INSTANCE.getSettingsHandler()) {
            this.settingsHandler = null;
        }
    }

    private void migrateBackpackContents(UUID newUuid) {
        this.migrateNbtTag(newUuid, "inventory");
        this.migrateNbtTag(newUuid, "upgradeInventory");
    }

    private void migrateNbtTag(UUID newUuid, String key) {
        NBTHelper.getCompound((ItemStack)this.getBackpackStack(), (String)key).ifPresent(nbt -> {
            BackpackStorage.get().getOrCreateBackpackContents(newUuid).put(key, (Tag)nbt);
            this.markBackpackContentsDirty();
            NBTHelper.removeTag((ItemStack)this.getBackpackStack(), (String)key);
        });
    }

    public int getMainColor() {
        return NBTHelper.getInt((ItemStack)this.getBackpackStack(), (String)CLOTH_COLOR_TAG).orElse(13394234);
    }

    public int getAccentColor() {
        return NBTHelper.getInt((ItemStack)this.getBackpackStack(), (String)BORDER_COLOR_TAG).orElse(6434330);
    }

    public Optional<Integer> getOpenTabId() {
        return NBTHelper.getInt((ItemStack)this.getBackpackStack(), (String)OPEN_TAB_ID_TAG);
    }

    public void setOpenTabId(int openTabId) {
        NBTHelper.setInteger((ItemStack)this.getBackpackStack(), (String)OPEN_TAB_ID_TAG, (int)openTabId);
        this.backpackSaveHandler.run();
    }

    public void removeOpenTabId() {
        this.getBackpackStack().getOrCreateTag().remove(OPEN_TAB_ID_TAG);
        this.backpackSaveHandler.run();
    }

    public void setColors(int mainColor, int accentColor) {
        this.getBackpackStack().addTagElement(CLOTH_COLOR_TAG, (Tag)IntTag.valueOf((int)mainColor));
        this.getBackpackStack().addTagElement(BORDER_COLOR_TAG, (Tag)IntTag.valueOf((int)accentColor));
        this.backpackSaveHandler.run();
    }

    public void setSortBy(SortBy sortBy) {
        this.getBackpackStack().addTagElement(SORT_BY_TAG, (Tag)StringTag.valueOf((String)sortBy.getSerializedName()));
        this.backpackSaveHandler.run();
    }

    public SortBy getSortBy() {
        return NBTHelper.getEnumConstant((ItemStack)this.getBackpackStack(), (String)SORT_BY_TAG, SortBy::fromName).orElse(SortBy.NAME);
    }

    public void sort() {
        HashSet slotIndexesExcludedFromSort = new HashSet();
        slotIndexesExcludedFromSort.addAll(((NoSortSettingsCategory)this.getSettingsHandler().getTypeCategory(NoSortSettingsCategory.class)).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(((MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).getSlotIndexes());
        InventorySorter.sortHandler((IItemHandlerModifiable)this.getInventoryHandler(), this.getComparator(), slotIndexesExcludedFromSort);
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        return switch (this.getSortBy()) {
            default -> throw new IncompatibleClassChangeError();
            case SortBy.COUNT -> InventorySorter.BY_COUNT;
            case SortBy.TAGS -> InventorySorter.BY_TAGS;
            case SortBy.NAME -> InventorySorter.BY_NAME;
            case SortBy.MOD -> InventorySorter.BY_MOD;
        };
    }

    @Override
    public ItemStack getBackpack() {
        return this.getBackpackStack();
    }

    @Override
    public ItemStack cloneBackpack() {
        ItemStack clonedBackpack = this.cloneBackpack(this);
        this.cloneSubbackpacks(BackpackWrapper.fromData(clonedBackpack));
        return clonedBackpack;
    }

    private void cloneSubbackpacks(IStorageWrapper wrapperCloned) {
        InventoryHandler inventoryHandler = wrapperCloned.getInventoryHandler();
        InventoryHelper.iterate((IItemHandler)inventoryHandler, (slot, stack) -> {
            if (!(stack.getItem() instanceof BackpackItem)) {
                return;
            }
            inventoryHandler.setStackInSlot(slot.intValue(), this.cloneBackpack(BackpackWrapper.fromData(stack)));
        });
    }

    private ItemStack cloneBackpack(IBackpackWrapper originalWrapper) {
        ItemStack backpackCopy = originalWrapper.getBackpack().copy();
        backpackCopy.removeTagKey(CONTENTS_UUID_TAG);
        IBackpackWrapper wrapperCopy = BackpackWrapper.fromData(backpackCopy);
        originalWrapper.copyDataTo(wrapperCopy);
        return wrapperCopy.getBackpack();
    }

    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
        this.upgradeCachesInvalidatedHandler.run();
    }

    public void setPersistent(boolean persistent) {
        this.getInventoryHandler().setPersistent(persistent);
        this.getUpgradeHandler().setPersistent(persistent);
    }

    @Override
    public void setSlotNumbers(int numberOfInventorySlots, int numberOfUpgradeSlots) {
        this.setNumberOfInventorySlots(numberOfInventorySlots);
        this.setNumberOfUpgradeSlots(numberOfUpgradeSlots);
    }

    @Override
    public void setLoot(ResourceLocation lootTableName, float lootPercentage) {
        this.getBackpackStack().addTagElement(LOOT_TABLE_NAME_TAG, (Tag)StringTag.valueOf((String)lootTableName.toString()));
        this.getBackpackStack().addTagElement(LOOT_PERCENTAGE_TAG, (Tag)FloatTag.valueOf((float)lootPercentage));
        this.backpackSaveHandler.run();
    }

    public void fillWithLoot(Player playerEntity) {
        if (playerEntity.level().isClientSide) {
            return;
        }
        NBTHelper.getString((ItemStack)this.getBackpackStack(), (String)LOOT_TABLE_NAME_TAG).ifPresent(ltName -> this.fillWithLootFromTable(playerEntity, (String)ltName));
    }

    @Override
    public void setContentsUuid(UUID storageUuid) {
        NBTHelper.setUniqueId((ItemStack)this.getBackpackStack(), (String)CONTENTS_UUID_TAG, (UUID)storageUuid);
    }

    @Override
    public void removeContentsUuid() {
        this.getContentsUuid().ifPresent(BackpackStorage.get()::removeBackpackContents);
        this.removeContentsUUIDTag();
    }

    @Override
    public void removeContentsUUIDTag() {
        NBTHelper.removeTag((ItemStack)this.getBackpackStack(), (String)CONTENTS_UUID_TAG);
    }

    private ItemStack getBackpackStack() {
        if (this.backpack == null) {
            throw new IllegalStateException("Backpack stack not set");
        }
        return this.backpack;
    }

    public BackpackRenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    public void setColumnsTaken(int columnsTaken, boolean hasChanged) {
        int originalColumnsTaken = this.getColumnsTaken();
        NBTHelper.setInteger((ItemStack)this.getBackpackStack(), (String)COLUMNS_TAKEN_TAG, (int)columnsTaken);
        if (hasChanged) {
            int diff = (columnsTaken - originalColumnsTaken) * this.getNumberOfSlotRows();
            this.onSlotsChange.accept(diff);
        }
        this.backpackSaveHandler.run();
    }

    @Override
    public void registerOnSlotsChangeListener(IntConsumer onSlotsChange) {
        this.onSlotsChange = onSlotsChange;
    }

    @Override
    public void unregisterOnSlotsChangeListener() {
        this.onSlotsChange = diff -> {};
    }

    public int getColumnsTaken() {
        return NBTHelper.getInt((ItemStack)this.getBackpackStack(), (String)COLUMNS_TAKEN_TAG).orElse(0);
    }

    private void fillWithLootFromTable(Player playerEntity, String lootName) {
        Level level;
        MinecraftServer server = playerEntity.level().getServer();
        if (server == null || !((level = playerEntity.level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ResourceLocation lootTableName = new ResourceLocation(lootName);
        float lootPercentage = NBTHelper.getFloat((ItemStack)this.getBackpackStack(), (String)LOOT_PERCENTAGE_TAG).orElse(Float.valueOf(0.0f)).floatValue();
        this.getBackpackStack().removeTagKey(LOOT_TABLE_NAME_TAG);
        this.getBackpackStack().removeTagKey(LOOT_PERCENTAGE_TAG);
        List loot = LootHelper.getLoot((ResourceLocation)lootTableName, (MinecraftServer)server, (ServerLevel)serverLevel, (Entity)playerEntity);
        loot.removeIf(stack -> stack.getItem() instanceof BackpackItem);
        loot = RandHelper.getNRandomElements((List)loot, (int)((int)((float)loot.size() * lootPercentage)));
        LootHelper.fillWithLoot((RandomSource)serverLevel.random, (List)loot, (IItemHandlerModifiable)this.getInventoryHandler());
    }

    private void setNumberOfUpgradeSlots(int numberOfUpgradeSlots) {
        NBTHelper.setInteger((ItemStack)this.getBackpackStack(), (String)UPGRADE_SLOTS_TAG, (int)numberOfUpgradeSlots);
    }

    public void refreshInventoryForUpgradeProcessing() {
        this.inventoryModificationHandler = null;
        this.fluidHandler = null;
        this.fluidHandlerInitialized = false;
        this.energyStorage = null;
        this.energyStorageInitialized = false;
        this.refreshInventoryForInputOutput();
    }

    public void onContentsNbtUpdated() {
        this.handler = null;
        this.upgradeHandler = null;
        this.refreshInventoryForUpgradeProcessing();
        this.onInventoryHandlerRefresh.run();
    }

    @Override
    public void registerOnInventoryHandlerRefreshListener(Runnable onInventoryHandlerRefresh) {
        this.onInventoryHandlerRefresh = onInventoryHandlerRefresh;
    }

    @Override
    public void unregisterOnInventoryHandlerRefreshListener() {
        this.onInventoryHandlerRefresh = () -> {};
    }

    public ItemStack getWrappedStorageStack() {
        return this.getBackpack();
    }

    public String getStorageType() {
        return "backpack";
    }

    public Component getDisplayName() {
        return this.getBackpack().getHoverName();
    }

    private static class FluidHandlerItemWrapper
    implements IFluidHandlerItem {
        private final IFluidHandler delegate;
        private final ItemStack container;

        public FluidHandlerItemWrapper(ItemStack container, IFluidHandler delegate) {
            this.container = container;
            this.delegate = delegate;
        }

        public ItemStack getContainer() {
            return this.container;
        }

        public int getTanks() {
            return this.delegate.getTanks();
        }

        public FluidStack getFluidInTank(int tank) {
            return this.delegate.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.delegate.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.delegate.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.delegate.fill(resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.delegate.drain(resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.delegate.drain(maxDrain, action);
        }
    }
}

